/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.parsers.ByteArrayHexParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

@MissingNullInOutFunction
public class ABinaryHexStringConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ABinaryHexStringConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ABinaryConstructorEvaluator(args[0], (IValueParserFactory)ByteArrayHexParserFactory.INSTANCE, ctx, ABinaryHexStringConstructorDescriptor.this.sourceLoc);
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BINARY_HEX_CONSTRUCTOR;
    }

    static class ABinaryConstructorEvaluator
    implements IScalarEvaluator {
        private final SourceLocation sourceLoc;
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private final DataOutput out = this.resultStorage.getDataOutput();
        private final IPointable inputArg = new VoidPointable();
        private final IScalarEvaluator eval;
        private IValueParser byteArrayParser;
        private UTF8StringPointable utf8Ptr = new UTF8StringPointable();

        public ABinaryConstructorEvaluator(IScalarEvaluatorFactory copyEvaluatorFactory, IValueParserFactory valueParserFactory, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
            this.sourceLoc = sourceLoc;
            this.eval = copyEvaluatorFactory.createScalarEvaluator(context);
            this.byteArrayParser = valueParserFactory.createValueParser();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            block6: {
                try {
                    this.eval.evaluate(tuple, this.inputArg);
                    if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                        return;
                    }
                    byte[] binary = this.inputArg.getByteArray();
                    int startOffset = this.inputArg.getStartOffset();
                    int len = this.inputArg.getLength();
                    byte tt = binary[startOffset];
                    if (tt == ATypeTag.SERIALIZED_BINARY_TYPE_TAG) {
                        result.set((IValueReference)this.inputArg);
                        break block6;
                    }
                    if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                        this.resultStorage.reset();
                        this.utf8Ptr.set(this.inputArg.getByteArray(), startOffset + 1, len - 1);
                        char[] buffer = this.utf8Ptr.toString().toCharArray();
                        this.out.write(ATypeTag.BINARY.serialize());
                        if (!this.byteArrayParser.parse(buffer, 0, buffer.length, this.out)) {
                            PointableHelper.setNull(result);
                            return;
                        }
                        result.set((IValueReference)this.resultStorage);
                        break block6;
                    }
                    throw new TypeMismatchException(this.sourceLoc, BuiltinFunctions.BINARY_HEX_CONSTRUCTOR, (Integer)0, tt, ATypeTag.SERIALIZED_BINARY_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                }
                catch (IOException e) {
                    throw new InvalidDataFormatException(this.sourceLoc, BuiltinFunctions.BINARY_HEX_CONSTRUCTOR, e, ATypeTag.SERIALIZED_BINARY_TYPE_TAG);
                }
            }
        }
    }
}

