/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.executor;

public final class Runnability {
    private final Tag tag;
    private final int priority;

    public Runnability(Tag tag, int priority) {
        this.tag = tag;
        this.priority = priority;
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getPriority() {
        return this.priority;
    }

    public static Runnability getWorstCase(Runnability r1, Runnability r2) {
        switch (r1.tag) {
            case COMPLETED: {
                switch (r2.tag) {
                    case COMPLETED: 
                    case NOT_RUNNABLE: 
                    case RUNNABLE: 
                    case RUNNING: {
                        return r2;
                    }
                }
                break;
            }
            case NOT_RUNNABLE: {
                switch (r2.tag) {
                    case COMPLETED: 
                    case NOT_RUNNABLE: 
                    case RUNNABLE: 
                    case RUNNING: {
                        return r1;
                    }
                }
                break;
            }
            case RUNNABLE: {
                switch (r2.tag) {
                    case COMPLETED: {
                        return r1;
                    }
                    case RUNNING: {
                        return r1.priority > 0 ? r1 : new Runnability(Tag.RUNNABLE, 1);
                    }
                    case NOT_RUNNABLE: {
                        return r2;
                    }
                    case RUNNABLE: {
                        return r1.priority > r2.priority ? r1 : r2;
                    }
                }
                break;
            }
            case RUNNING: {
                switch (r2.tag) {
                    case COMPLETED: 
                    case RUNNING: {
                        return r1;
                    }
                    case NOT_RUNNABLE: {
                        return r2;
                    }
                    case RUNNABLE: {
                        return r2.priority > 0 ? r2 : new Runnability(Tag.RUNNABLE, 1);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Could not aggregate: " + r1 + " and " + r2);
    }

    public String toString() {
        return "{" + (Object)((Object)this.tag) + ", " + this.priority + "}";
    }

    public static enum Tag {
        COMPLETED,
        NOT_RUNNABLE,
        RUNNABLE,
        RUNNING;

    }
}

