/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FsUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private Configuration conf;
    private Map<String, Boolean> protocols = new ConcurrentHashMap<String, Boolean>();
    private URLStreamHandler handler;

    public FsUrlStreamHandlerFactory() {
        this(new Configuration());
    }

    public FsUrlStreamHandlerFactory(Configuration conf) {
        this.conf = new Configuration(conf);
        try {
            FileSystem.getFileSystemClass("file", conf);
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        this.handler = new FsUrlStreamHandler(this.conf);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!this.protocols.containsKey(protocol)) {
            boolean known = true;
            try {
                FileSystem.getFileSystemClass(protocol, this.conf);
            }
            catch (IOException ex) {
                known = false;
            }
            this.protocols.put(protocol, known);
        }
        if (this.protocols.get(protocol).booleanValue()) {
            return this.handler;
        }
        return null;
    }
}

