/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.Iterator;
import java.util.List;

public class CategoriesDistribution {
    private static final int NUM_WEIGHT_FIELDS = 1;
    private static final String VALUES_AND_WEIGHTS_FILENAME = "categories.dst";
    private static final CategoriesDistribution CATEGORIES_DISTRIBUTION = CategoriesDistribution.buildCategoriesDistribution();
    private final ImmutableList<String> names;
    private final ImmutableList<Integer> hasSizes;
    private final ImmutableList<Integer> weights;

    private CategoriesDistribution(ImmutableList<String> names, ImmutableList<Integer> hasSizes, ImmutableList<Integer> weights) {
        this.names = names;
        this.hasSizes = hasSizes;
        this.weights = weights;
    }

    private static CategoriesDistribution buildCategoriesDistribution() {
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder hasSizesBuilder = ImmutableList.builder();
        DistributionUtils.WeightsBuilder weightsBuilder = new DistributionUtils.WeightsBuilder();
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(VALUES_AND_WEIGHTS_FILENAME);
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == 3 ? 1 : 0) != 0, (String)"Expected line to contain 3 values, but it contained %d, %s", (Object[])new Object[]{values.size(), values});
            namesBuilder.add((Object)values.get(0));
            hasSizesBuilder.add((Object)Integer.parseInt(values.get(2)));
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == 1 ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object[])new Object[]{1, weights.size(), values});
            weightsBuilder.computeAndAddNextWeight(Integer.parseInt(weights.get(0)));
        }
        return new CategoriesDistribution((ImmutableList<String>)namesBuilder.build(), (ImmutableList<Integer>)hasSizesBuilder.build(), weightsBuilder.build());
    }

    public static Integer pickRandomIndex(RandomNumberStream stream) {
        return DistributionUtils.pickRandomIndex(CategoriesDistribution.CATEGORIES_DISTRIBUTION.weights, stream);
    }

    public static String getCategoryAtIndex(int index) {
        return (String)CategoriesDistribution.CATEGORIES_DISTRIBUTION.names.get(index);
    }

    public static int getHasSizeAtIndex(int index) {
        return (Integer)CategoriesDistribution.CATEGORIES_DISTRIBUTION.hasSizes.get(index);
    }
}

