/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicateFileTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String file;
    private final long size;
    private final boolean indexMetadata;

    public ReplicateFileTask(String file, long size, boolean indexMetadata) {
        this.file = file;
        this.size = size;
        this.indexMetadata = indexMetadata;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            LOGGER.info("attempting to replicate {}", (Object)this);
            IIOManager ioManager = appCtx.getIoManager();
            FileReference localPath = ioManager.resolve(this.file);
            Path resourceDir = Files.createDirectories(localPath.getFile().getParentFile().toPath(), new FileAttribute[0]);
            Path maskPath = Paths.get(resourceDir.toString(), ".mask_" + localPath.getFile().getName());
            Files.createFile(maskPath, new FileAttribute[0]);
            Path filePath = Paths.get(resourceDir.toString(), localPath.getFile().getName());
            Files.createFile(filePath, new FileAttribute[0]);
            try (RandomAccessFile fileOutputStream = new RandomAccessFile(filePath.toFile(), "rw");
                 FileChannel fileChannel = fileOutputStream.getChannel();){
                fileOutputStream.setLength(this.size);
                NetworkingUtil.downloadFile(fileChannel, worker.getChannel());
                fileChannel.force(true);
            }
            if (this.indexMetadata) {
                this.initIndexCheckpoint(appCtx);
            }
            Files.delete(maskPath);
            LOGGER.info(() -> "Replicated file: " + localPath);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private void initIndexCheckpoint(INcApplicationContext appCtx) throws HyracksDataException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long currentLSN = appCtx.getTransactionSubsystem().getLogManager().getAppendLSN();
        indexCheckpointManager.delete();
        indexCheckpointManager.init(Long.MIN_VALUE, currentLSN, LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID.getMaxId());
        LOGGER.info(() -> "Checkpoint index: " + indexRef);
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.REPLICATE_RESOURCE_FILE;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
            dos.writeLong(this.size);
            dos.writeBoolean(this.indexMetadata);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ReplicateFileTask create(DataInput input) throws IOException {
        String s = input.readUTF();
        long i = input.readLong();
        boolean isMetadata = input.readBoolean();
        return new ReplicateFileTask(s, i, isMetadata);
    }

    public String toString() {
        return "ReplicateFileTask{file='" + this.file + "', size=" + this.size + ", indexMetadata=" + this.indexMetadata + "}";
    }
}

