/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.DataOutput;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ArrayConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AtomicConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ObjectConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.RepeatedConverter;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;

abstract class AbstractComplexConverter
extends GroupConverter
implements IFieldValue {
    protected final AbstractComplexConverter parent;
    private final IValueReference fieldName;
    private final int index;
    private final Converter[] converters;
    protected final ParserContext context;
    protected IMutableValueStorage tempStorage;

    public AbstractComplexConverter(AbstractComplexConverter parent, int index, GroupType parquetType, ParserContext context) {
        this(parent, null, index, parquetType, context);
    }

    public AbstractComplexConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, GroupType parquetType, ParserContext context) {
        this.parent = parent;
        this.fieldName = fieldName;
        this.index = index;
        this.context = context;
        this.converters = new Converter[parquetType.getFieldCount()];
        for (int i = 0; i < parquetType.getFieldCount(); ++i) {
            Type type = parquetType.getType(i);
            this.converters[i] = type.isPrimitive() ? this.createAtomicConverter(parquetType, i) : (type.getOriginalType() == OriginalType.LIST ? this.createArrayConverter(parquetType, i) : (type.getRepetition() == Type.Repetition.REPEATED ? this.createRepeatedConverter(parquetType, i) : this.createObjectConverter(parquetType, i)));
        }
    }

    protected abstract void addValue(IFieldValue var1);

    protected abstract AtomicConverter createAtomicConverter(GroupType var1, int var2);

    protected abstract ArrayConverter createArrayConverter(GroupType var1, int var2);

    protected abstract ObjectConverter createObjectConverter(GroupType var1, int var2);

    public AbstractComplexConverter createRepeatedConverter(GroupType type, int index) {
        GroupType arrayType = type.getType(index).asGroupType();
        if (arrayType.getFieldCount() == 1) {
            return new RepeatedConverter(this, index, arrayType, this.context);
        }
        return new ObjectConverter(this, index, arrayType, this.context);
    }

    @Override
    public IValueReference getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    protected DataOutput getDataOutput() {
        this.tempStorage.reset();
        return this.tempStorage.getDataOutput();
    }

    protected IMutableValueStorage getValue() {
        return this.tempStorage;
    }

    protected DataOutput getParentDataOutput() {
        return this.parent.getDataOutput();
    }

    protected void addThisValueToParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.addValue(this);
    }
}

