/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.operators.FeedMetaComputeNodePushable;
import org.apache.asterix.external.operators.FeedMetaStoreNodePushable;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class FeedMetaOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IOperatorDescriptor coreOperator;
    private final FeedConnectionId feedConnectionId;
    private final Map<String, String> feedPolicyProperties;
    private final FeedUtils.FeedRuntimeType runtimeType;
    private final boolean hasMessage;

    public FeedMetaOperatorDescriptor(JobSpecification spec, FeedConnectionId feedConnectionId, IOperatorDescriptor coreOperatorDescriptor, Map<String, String> feedPolicyProperties, FeedUtils.FeedRuntimeType runtimeType, boolean hasMessage) {
        super((IOperatorDescriptorRegistry)spec, coreOperatorDescriptor.getInputArity(), coreOperatorDescriptor.getOutputArity());
        this.feedConnectionId = feedConnectionId;
        this.feedPolicyProperties = feedPolicyProperties;
        if (coreOperatorDescriptor.getOutputRecordDescriptors().length == 1) {
            this.outRecDescs[0] = coreOperatorDescriptor.getOutputRecordDescriptors()[0];
        }
        this.coreOperator = coreOperatorDescriptor;
        this.runtimeType = runtimeType;
        this.hasMessage = hasMessage;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        AbstractUnaryInputUnaryOutputOperatorNodePushable nodePushable = null;
        switch (this.runtimeType) {
            case COMPUTE: {
                nodePushable = new FeedMetaComputeNodePushable(ctx, recordDescProvider, partition, nPartitions, this.coreOperator, this.feedConnectionId, this.feedPolicyProperties, this);
                break;
            }
            case STORE: {
                nodePushable = new FeedMetaStoreNodePushable(ctx, recordDescProvider, partition, nPartitions, this.coreOperator, this.feedConnectionId, this.feedPolicyProperties, this, this.hasMessage);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.OPERATORS_FEED_META_OPERATOR_DESCRIPTOR_INVALID_RUNTIME, new Serializable[]{this.runtimeType});
            }
        }
        return nodePushable;
    }

    public String toString() {
        return "FeedMeta [" + this.coreOperator + " ]";
    }

    public IOperatorDescriptor getCoreOperator() {
        return this.coreOperator;
    }

    public FeedUtils.FeedRuntimeType getRuntimeType() {
        return this.runtimeType;
    }
}

