/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.HttpProxyExceptionHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.proxy.ProxyHandler;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.tcp.TcpClient;

class NettyAsyncHttpClient
implements HttpClient {
    private final EventLoopGroup eventLoopGroup;
    private final Supplier<ProxyHandler> proxyHandlerSupplier;
    private final Pattern nonProxyHostsPattern;
    private final boolean disableBufferCopy;
    final reactor.netty.http.client.HttpClient nettyClient;

    NettyAsyncHttpClient() {
        this(reactor.netty.http.client.HttpClient.create(), null, null, null, false);
    }

    NettyAsyncHttpClient(reactor.netty.http.client.HttpClient nettyClient, EventLoopGroup eventLoopGroup, Supplier<ProxyHandler> proxyHandlerSupplier, String nonProxyHosts, boolean disableBufferCopy) {
        this.nettyClient = nettyClient;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyHandlerSupplier = proxyHandlerSupplier;
        this.nonProxyHostsPattern = nonProxyHosts == null ? null : Pattern.compile(nonProxyHosts, 2);
        this.disableBufferCopy = disableBufferCopy;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        return ((HttpClient.RequestSender)this.nettyClient.tcpConfiguration(tcpClient -> this.configureTcpClient((TcpClient)tcpClient, request.getUrl().getHost())).request(HttpMethod.valueOf((String)request.getHttpMethod().toString())).uri(request.getUrl().toString())).send(NettyAsyncHttpClient.bodySendDelegate(request)).responseConnection(NettyAsyncHttpClient.responseDelegate(request, this.disableBufferCopy)).single();
    }

    private TcpClient configureTcpClient(TcpClient tcpClient, String host) {
        if (this.eventLoopGroup != null) {
            tcpClient = tcpClient.runOn(this.eventLoopGroup);
        }
        if (this.nonProxyHostsPattern == null || !this.nonProxyHostsPattern.matcher(host).matches()) {
            ProxyHandler proxyHandler;
            ProxyHandler proxyHandler2 = proxyHandler = this.proxyHandlerSupplier == null ? null : this.proxyHandlerSupplier.get();
            if (proxyHandler != null) {
                tcpClient = tcpClient.bootstrap(bootstrap -> BootstrapHandlers.updateConfiguration((Bootstrap)bootstrap, (String)"reactor.left.proxyHandler", (connectionObserver, channel) -> channel.pipeline().addFirst("reactor.left.proxyHandler", (ChannelHandler)proxyHandler).addLast("azure.proxy.exceptionHandler", (ChannelHandler)new HttpProxyExceptionHandler())));
            }
        }
        return tcpClient;
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader header : restRequest.getHeaders()) {
                if (header.getValue() == null) continue;
                reactorNettyRequest.header((CharSequence)header.getName(), (CharSequence)header.getValue());
            }
            if (restRequest.getBody() != null) {
                Flux nettyByteBufFlux = restRequest.getBody().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send((Publisher)nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static BiFunction<HttpClientResponse, Connection, Publisher<HttpResponse>> responseDelegate(HttpRequest restRequest, boolean disableBufferCopy) {
        return (reactorNettyResponse, reactorNettyConnection) -> Mono.just((Object)((Object)new ReactorNettyHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection, restRequest, disableBufferCopy)));
    }

    static class ReactorNettyHttpResponse
    extends HttpResponse {
        private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
        private final HttpClientResponse reactorNettyResponse;
        private final Connection reactorNettyConnection;
        private final boolean disableBufferCopy;

        ReactorNettyHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection, HttpRequest httpRequest, boolean disableBufferCopy) {
            super(httpRequest);
            this.reactorNettyResponse = reactorNettyResponse;
            this.reactorNettyConnection = reactorNettyConnection;
            this.disableBufferCopy = disableBufferCopy;
        }

        public int getStatusCode() {
            return this.reactorNettyResponse.status().code();
        }

        public String getHeaderValue(String name) {
            return this.reactorNettyResponse.responseHeaders().get(name);
        }

        public HttpHeaders getHeaders() {
            HttpHeaders headers = new HttpHeaders();
            this.reactorNettyResponse.responseHeaders().forEach(e -> headers.put((String)e.getKey(), (String)e.getValue()));
            return headers;
        }

        public Flux<ByteBuffer> getBody() {
            return this.bodyIntern().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            }).map(byteBuf -> this.disableBufferCopy ? byteBuf.nioBuffer() : ReactorNettyHttpResponse.deepCopyBuffer(byteBuf));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return this.bodyIntern().aggregate().asByteArray().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        public Mono<String> getBodyAsString() {
            return this.bodyIntern().aggregate().asString().doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return this.bodyIntern().aggregate().asString(charset).doFinally(s -> {
                if (!this.reactorNettyConnection.isDisposed()) {
                    this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
                }
            });
        }

        public void close() {
            if (!this.reactorNettyConnection.isDisposed()) {
                this.reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)this.reactorNettyConnection).dispose());
            }
        }

        private ByteBufFlux bodyIntern() {
            return this.reactorNettyConnection.inbound().receive();
        }

        Connection internConnection() {
            return this.reactorNettyConnection;
        }

        private static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
            ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
            byteBuf.readBytes(buffer);
            buffer.rewind();
            return buffer;
        }
    }
}

