/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.connectors.ConnectorPolicyFactory;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.common.job.TaskAttemptDescriptor;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCNCFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FID_CODE_SIZE = 1;

    private static PartitionId readPartitionId(DataInputStream dis) throws IOException {
        long jobId = dis.readLong();
        int cdid = dis.readInt();
        int senderIndex = dis.readInt();
        int receiverIndex = dis.readInt();
        PartitionId pid = new PartitionId(new JobId(jobId), new ConnectorDescriptorId(cdid), senderIndex, receiverIndex);
        return pid;
    }

    private static void writePartitionId(DataOutputStream dos, PartitionId pid) throws IOException {
        dos.writeLong(pid.getJobId().getId());
        dos.writeInt(pid.getConnectorDescriptorId().getId());
        dos.writeInt(pid.getSenderIndex());
        dos.writeInt(pid.getReceiverIndex());
    }

    private static TaskAttemptId readTaskAttemptId(DataInputStream dis) throws IOException {
        int odid = dis.readInt();
        int aid = dis.readInt();
        int partition = dis.readInt();
        int attempt = dis.readInt();
        TaskAttemptId taId = new TaskAttemptId(new TaskId(new ActivityId(new OperatorDescriptorId(odid), aid), partition), attempt);
        return taId;
    }

    private static void writeTaskAttemptId(DataOutputStream dos, TaskAttemptId taId) throws IOException {
        TaskId tid = taId.getTaskId();
        ActivityId aid = tid.getActivityId();
        OperatorDescriptorId odId = aid.getOperatorDescriptorId();
        dos.writeInt(odId.getId());
        dos.writeInt(aid.getLocalId());
        dos.writeInt(tid.getPartition());
        dos.writeInt(taId.getAttempt());
    }

    private static PartitionState readPartitionState(DataInputStream dis) throws IOException {
        PartitionState state = PartitionState.values()[dis.readInt()];
        return state;
    }

    private static void writePartitionState(DataOutputStream dos, PartitionState state) throws IOException {
        dos.writeInt(state.ordinal());
    }

    private static NetworkAddress readNetworkAddress(DataInputStream dis) throws IOException {
        String address = dis.readUTF();
        int port = dis.readInt();
        NetworkAddress networkAddress = new NetworkAddress(address, port);
        return networkAddress;
    }

    private static void writeNetworkAddress(DataOutputStream dos, NetworkAddress networkAddress) throws IOException {
        dos.writeUTF(networkAddress.getAddress());
        dos.writeInt(networkAddress.getPort());
    }

    public static class SerializerDeserializer
    implements IPayloadSerializerDeserializer {
        private final JavaSerializationBasedPayloadSerializerDeserializer javaSerde = new JavaSerializationBasedPayloadSerializerDeserializer();

        public Object deserializeObject(ByteBuffer buffer, int length, byte flag) throws Exception {
            if (length < 1) {
                throw new IllegalStateException("Message size too small: " + length);
            }
            byte fid = buffer.get();
            return this.deserialize(fid, buffer, length - 1, flag);
        }

        public Exception deserializeException(ByteBuffer buffer, int length) throws Exception {
            if (length < 1) {
                throw new IllegalStateException("Message size too small: " + length);
            }
            byte fid = buffer.get();
            if (fid != FunctionId.OTHER.ordinal()) {
                throw new IllegalStateException("Expected FID for OTHER, found: " + fid);
            }
            return (Exception)this.deserialize(fid, buffer, length - 1, (byte)3);
        }

        public byte[] serializeObject(Object object) throws Exception {
            if (object instanceof Function) {
                Function fn = (Function)object;
                return this.serialize(object, (byte)fn.getFunctionId().ordinal());
            }
            return this.serialize(object, (byte)FunctionId.OTHER.ordinal());
        }

        public byte[] serializeException(Exception object) throws Exception {
            return this.serialize(object, (byte)FunctionId.OTHER.ordinal());
        }

        private byte[] serialize(Object object, byte fid) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(fid);
            try {
                this.serialize(baos, object, fid);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Error serializing " + object, (Throwable)e);
                throw e;
            }
            baos.close();
            return baos.toByteArray();
        }

        private void serialize(OutputStream out, Object object, byte fid) throws Exception {
            switch (FunctionId.values()[fid]) {
                case REGISTER_PARTITION_PROVIDER: {
                    RegisterPartitionProviderFunction.serialize(out, object);
                    return;
                }
                case REGISTER_PARTITION_REQUEST: {
                    RegisterPartitionRequestFunction.serialize(out, object);
                    return;
                }
                case REPORT_PARTITION_AVAILABILITY: {
                    ReportPartitionAvailabilityFunction.serialize(out, object);
                    return;
                }
                case NODE_HEARTBEAT: {
                    NodeHeartbeatFunction.serialize(out, object);
                    return;
                }
                case START_TASKS: {
                    StartTasksFunction.serialize(out, object);
                    return;
                }
                case NOTIFY_TASK_COMPLETE: {
                    NotifyTaskCompleteFunction.serialize(out, object);
                    return;
                }
                case NOTIFY_JOBLET_CLEANUP: {
                    NotifyJobletCleanupFunction.serialize(out, object);
                    return;
                }
                case CLEANUP_JOBLET: {
                    CleanupJobletFunction.serialize(out, object);
                    return;
                }
            }
            JavaSerializationBasedPayloadSerializerDeserializer.serialize((OutputStream)out, (Object)object);
        }

        private Object deserialize(byte fid, ByteBuffer buffer, int length, byte flag) throws Exception {
            switch (FunctionId.values()[fid]) {
                case REGISTER_PARTITION_PROVIDER: {
                    return RegisterPartitionProviderFunction.deserialize(buffer, length);
                }
                case REGISTER_PARTITION_REQUEST: {
                    return RegisterPartitionRequestFunction.deserialize(buffer, length);
                }
                case REPORT_PARTITION_AVAILABILITY: {
                    return ReportPartitionAvailabilityFunction.deserialize(buffer, length);
                }
                case NODE_HEARTBEAT: {
                    return NodeHeartbeatFunction.deserialize(buffer, length);
                }
                case START_TASKS: {
                    return StartTasksFunction.deserialize(buffer, length);
                }
                case NOTIFY_TASK_COMPLETE: {
                    return NotifyTaskCompleteFunction.deserialize(buffer, length);
                }
                case NOTIFY_JOBLET_CLEANUP: {
                    return NotifyJobletCleanupFunction.deserialize(buffer, length);
                }
                case CLEANUP_JOBLET: {
                    return CleanupJobletFunction.deserialize(buffer, length);
                }
            }
            return this.javaSerde.deserializeObject(buffer, length, flag);
        }
    }

    public static class PingResponseFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;

        public PingResponseFunction(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.PING_RESPONSE;
        }
    }

    public static class ShutdownResponseFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;

        public ShutdownResponseFunction(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.SHUTDOWN_RESPONSE;
        }
    }

    public static class ShutdownRequestFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final boolean terminateNCService;

        public ShutdownRequestFunction(boolean terminateNCService, CcId ccId) {
            super(ccId);
            this.terminateNCService = terminateNCService;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.SHUTDOWN_REQUEST;
        }

        public boolean isTerminateNCService() {
            return this.terminateNCService;
        }
    }

    public static class NodeHeartbeatAckFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final HyracksDataException exception;

        public NodeHeartbeatAckFunction(CcId ccId, HyracksDataException e) {
            super(ccId);
            this.exception = e;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NODE_HEARTBEAT_ACK;
        }

        public HyracksDataException getException() {
            return this.exception;
        }
    }

    public static class PingFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;

        public PingFunction(CcId ccId) {
            super(ccId);
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.PING_REQUEST;
        }
    }

    public static class StateDumpResponseFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;
        private final String stateDumpId;
        private final String state;

        public StateDumpResponseFunction(String nodeId, String stateDumpId, String state) {
            this.nodeId = nodeId;
            this.stateDumpId = stateDumpId;
            this.state = state;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getStateDumpId() {
            return this.stateDumpId;
        }

        public String getState() {
            return this.state;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.STATE_DUMP_RESPONSE;
        }
    }

    public static class StateDumpRequestFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final String stateDumpId;

        public StateDumpRequestFunction(String stateDumpId, CcId ccId) {
            super(ccId);
            this.stateDumpId = stateDumpId;
        }

        public String getStateDumpId() {
            return this.stateDumpId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.STATE_DUMP_REQUEST;
        }
    }

    public static class NotifyDeployBinaryFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;
        private final DeploymentId deploymentId;
        private final DeploymentStatus deploymentStatus;

        public NotifyDeployBinaryFunction(DeploymentId deploymentId, String nodeId, DeploymentStatus deploymentStatus) {
            this.nodeId = nodeId;
            this.deploymentId = deploymentId;
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NOTIFY_DEPLOY_BINARY;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public DeploymentId getDeploymentId() {
            return this.deploymentId;
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }
    }

    public static class NotifyShutdownFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;

        public NotifyShutdownFunction(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.SHUTDOWN_RESPONSE;
        }

        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class RequestShutdownFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.SHUTDOWN_REQUEST;
        }
    }

    public static class UnDeployBinaryFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final DeploymentId deploymentId;

        public UnDeployBinaryFunction(DeploymentId deploymentId, CcId ccId) {
            super(ccId);
            this.deploymentId = deploymentId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.UNDEPLOY_BINARY;
        }

        public DeploymentId getDeploymentId() {
            return this.deploymentId;
        }
    }

    public static class DeployBinaryFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final List<URL> binaryURLs;
        private final DeploymentId deploymentId;

        public DeployBinaryFunction(DeploymentId deploymentId, List<URL> binaryURLs, CcId ccId) {
            super(ccId);
            this.binaryURLs = binaryURLs;
            this.deploymentId = deploymentId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.DEPLOY_BINARY;
        }

        public List<URL> getBinaryURLs() {
            return this.binaryURLs;
        }

        public DeploymentId getDeploymentId() {
            return this.deploymentId;
        }
    }

    public static class ReportPartitionAvailabilityFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final PartitionId pid;
        private final NetworkAddress networkAddress;

        public ReportPartitionAvailabilityFunction(PartitionId pid, NetworkAddress networkAddress) {
            this.pid = pid;
            this.networkAddress = networkAddress;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REPORT_PARTITION_AVAILABILITY;
        }

        public PartitionId getPartitionId() {
            return this.pid;
        }

        public NetworkAddress getNetworkAddress() {
            return this.networkAddress;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            PartitionId pid = CCNCFunctions.readPartitionId(dis);
            NetworkAddress networkAddress = CCNCFunctions.readNetworkAddress(dis);
            return new ReportPartitionAvailabilityFunction(pid, networkAddress);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            ReportPartitionAvailabilityFunction fn = (ReportPartitionAvailabilityFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            CCNCFunctions.writePartitionId(dos, fn.getPartitionId());
            CCNCFunctions.writeNetworkAddress(dos, fn.getNetworkAddress());
        }
    }

    public static class ThreadDumpResponseFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;
        private final String requestId;
        private final String threadDumpJSON;

        public ThreadDumpResponseFunction(String nodeId, String requestId, String threadDumpJSON) {
            this.nodeId = nodeId;
            this.requestId = requestId;
            this.threadDumpJSON = threadDumpJSON;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.THREAD_DUMP_RESPONSE;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getThreadDumpJSON() {
            return this.threadDumpJSON;
        }
    }

    public static class ThreadDumpRequestFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final String requestId;

        public ThreadDumpRequestFunction(String requestId, CcId ccId) {
            super(ccId);
            this.requestId = requestId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.THREAD_DUMP_REQUEST;
        }

        public String getRequestId() {
            return this.requestId;
        }
    }

    public static class GetNodeControllersInfoResponseFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final Map<String, NodeControllerInfo> ncInfos;

        public GetNodeControllersInfoResponseFunction(Map<String, NodeControllerInfo> ncInfos) {
            this.ncInfos = ncInfos;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.GET_NODE_CONTROLLERS_INFO_RESPONSE;
        }

        public Map<String, NodeControllerInfo> getNodeControllerInfos() {
            return this.ncInfos;
        }
    }

    public static class GetNodeControllersInfoFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.GET_NODE_CONTROLLERS_INFO;
        }
    }

    public static class CleanupJobletFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final JobStatus status;

        public CleanupJobletFunction(JobId jobId, JobStatus status) {
            this.jobId = jobId;
            this.status = status;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.CLEANUP_JOBLET;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public JobStatus getStatus() {
            return this.status;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            JobId jobId = JobId.create((DataInput)dis);
            JobStatus status = JobStatus.values()[dis.readInt()];
            return new CleanupJobletFunction(jobId, status);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            CleanupJobletFunction fn = (CleanupJobletFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            fn.jobId.writeFields((DataOutput)dos);
            dos.writeInt(fn.status.ordinal());
        }
    }

    public static class AbortTasksFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final List<TaskAttemptId> tasks;

        public AbortTasksFunction(JobId jobId, List<TaskAttemptId> tasks) {
            this.jobId = jobId;
            this.tasks = tasks;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.ABORT_TASKS;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public List<TaskAttemptId> getTasks() {
            return this.tasks;
        }
    }

    public static class StartTasksFunction
    extends Function {
        private static final long serialVersionUID = 2L;
        private final DeploymentId deploymentId;
        private final JobId jobId;
        private final byte[] planBytes;
        private final List<TaskAttemptDescriptor> taskDescriptors;
        private final Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies;
        private final Set<JobFlag> flags;
        private final Map<byte[], byte[]> jobParameters;
        private final DeployedJobSpecId deployedJobSpecId;
        private final long jobStartTime;

        public StartTasksFunction(DeploymentId deploymentId, JobId jobId, byte[] planBytes, List<TaskAttemptDescriptor> taskDescriptors, Map<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies, Set<JobFlag> flags, Map<byte[], byte[]> jobParameters, DeployedJobSpecId deployedJobSpecId, long jobStartTime) {
            this.deploymentId = deploymentId;
            this.jobId = jobId;
            this.planBytes = planBytes;
            this.taskDescriptors = taskDescriptors;
            this.connectorPolicies = connectorPolicies;
            this.flags = flags;
            this.jobParameters = jobParameters;
            this.deployedJobSpecId = deployedJobSpecId;
            this.jobStartTime = jobStartTime;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.START_TASKS;
        }

        public DeploymentId getDeploymentId() {
            return this.deploymentId;
        }

        public DeployedJobSpecId getDeployedJobSpecId() {
            return this.deployedJobSpecId;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public Map<byte[], byte[]> getJobParameters() {
            return this.jobParameters;
        }

        public byte[] getPlanBytes() {
            return this.planBytes;
        }

        public List<TaskAttemptDescriptor> getTaskDescriptors() {
            return this.taskDescriptors;
        }

        public Map<ConnectorDescriptorId, IConnectorPolicy> getConnectorPolicies() {
            return this.connectorPolicies;
        }

        public Set<JobFlag> getFlags() {
            return this.flags;
        }

        public long getJobStartTime() {
            return this.jobStartTime;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            JobId jobId = JobId.create((DataInput)dis);
            DeploymentId deploymentId = null;
            boolean hasDeployed = dis.readBoolean();
            if (hasDeployed) {
                deploymentId = DeploymentId.create((DataInput)dis);
            }
            int planBytesSize = dis.readInt();
            byte[] planBytes = null;
            if (planBytesSize >= 0) {
                planBytes = new byte[planBytesSize];
                dis.read(planBytes, 0, planBytesSize);
            }
            int tadSize = dis.readInt();
            ArrayList<TaskAttemptDescriptor> taskDescriptors = new ArrayList<TaskAttemptDescriptor>();
            for (int i = 0; i < tadSize; ++i) {
                TaskAttemptDescriptor tad = TaskAttemptDescriptor.create(dis);
                taskDescriptors.add(tad);
            }
            int cpSize = dis.readInt();
            HashMap<ConnectorDescriptorId, IConnectorPolicy> connectorPolicies = new HashMap<ConnectorDescriptorId, IConnectorPolicy>();
            for (int i = 0; i < cpSize; ++i) {
                ConnectorDescriptorId cid = ConnectorDescriptorId.create((DataInput)dis);
                IConnectorPolicy policy = ConnectorPolicyFactory.INSTANCE.getConnectorPolicy((DataInput)dis);
                connectorPolicies.put(cid, policy);
            }
            int flagSize = dis.readInt();
            EnumSet<JobFlag> flags = EnumSet.noneOf(JobFlag.class);
            for (int i = 0; i < flagSize; ++i) {
                flags.add(JobFlag.values()[dis.readInt()]);
            }
            int paramListSize = dis.readInt();
            HashMap<byte[], byte[]> jobParameters = new HashMap<byte[], byte[]>();
            for (int i = 0; i < paramListSize; ++i) {
                int nameLength = dis.readInt();
                byte[] nameBytes = null;
                if (nameLength >= 0) {
                    nameBytes = new byte[nameLength];
                    dis.read(nameBytes, 0, nameLength);
                }
                int valueLength = dis.readInt();
                byte[] valueBytes = null;
                if (valueLength >= 0) {
                    valueBytes = new byte[valueLength];
                    dis.read(valueBytes, 0, valueLength);
                }
                jobParameters.put(nameBytes, valueBytes);
            }
            DeployedJobSpecId deployedJobSpecId = null;
            if (dis.readBoolean()) {
                deployedJobSpecId = DeployedJobSpecId.create((DataInput)dis);
            }
            long jobStartTime = dis.readLong();
            return new StartTasksFunction(deploymentId, jobId, planBytes, taskDescriptors, connectorPolicies, flags, jobParameters, deployedJobSpecId, jobStartTime);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            StartTasksFunction fn = (StartTasksFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            fn.jobId.writeFields((DataOutput)dos);
            dos.writeBoolean(fn.deploymentId != null);
            if (fn.deploymentId != null) {
                fn.deploymentId.writeFields((DataOutput)dos);
            }
            dos.writeInt(fn.planBytes == null ? -1 : fn.planBytes.length);
            if (fn.planBytes != null) {
                dos.write(fn.planBytes, 0, fn.planBytes.length);
            }
            dos.writeInt(fn.taskDescriptors.size());
            for (int i = 0; i < fn.taskDescriptors.size(); ++i) {
                fn.taskDescriptors.get(i).writeFields(dos);
            }
            dos.writeInt(fn.connectorPolicies.size());
            for (Map.Entry<ConnectorDescriptorId, IConnectorPolicy> entry : fn.connectorPolicies.entrySet()) {
                entry.getKey().writeFields((DataOutput)dos);
                ConnectorPolicyFactory.INSTANCE.writeConnectorPolicy(entry.getValue(), (DataOutput)dos);
            }
            dos.writeInt(fn.flags.size());
            for (JobFlag jobFlag : fn.flags) {
                dos.writeInt(jobFlag.ordinal());
            }
            dos.writeInt(fn.jobParameters.size());
            for (Map.Entry<ConnectorDescriptorId, IConnectorPolicy> entry : fn.jobParameters.entrySet()) {
                dos.writeInt(((byte[])entry.getKey()).length);
                dos.write((byte[])entry.getKey(), 0, ((byte[])entry.getKey()).length);
                dos.writeInt(((byte[])entry.getValue()).length);
                dos.write((byte[])entry.getValue(), 0, ((byte[])entry.getValue()).length);
            }
            dos.writeBoolean(fn.getDeployedJobSpecId() != null);
            if (fn.getDeployedJobSpecId() != null) {
                fn.getDeployedJobSpecId().writeFields((DataOutput)dos);
            }
            dos.writeLong(fn.jobStartTime);
        }
    }

    public static class UndeployJobSpecFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final DeployedJobSpecId deployedJobSpecId;

        public UndeployJobSpecFunction(DeployedJobSpecId deployedJobSpecId, CcId ccId) {
            super(ccId);
            this.deployedJobSpecId = deployedJobSpecId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.UNDEPLOY_JOB;
        }

        public DeployedJobSpecId getDeployedJobSpecId() {
            return this.deployedJobSpecId;
        }
    }

    public static class DeployJobSpecFunction
    extends CCIdentifiedFunction {
        private static final long serialVersionUID = 1L;
        private final DeployedJobSpecId deployedJobSpecId;
        private final byte[] acgBytes;
        private final boolean upsert;

        public DeployJobSpecFunction(DeployedJobSpecId deployedJobSpecId, byte[] acgBytes, boolean upsert, CcId ccId) {
            super(ccId);
            this.deployedJobSpecId = deployedJobSpecId;
            this.acgBytes = acgBytes;
            this.upsert = upsert;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.DEPLOY_JOB;
        }

        public DeployedJobSpecId getDeployedJobSpecId() {
            return this.deployedJobSpecId;
        }

        public byte[] getacgBytes() {
            return this.acgBytes;
        }

        public boolean getUpsert() {
            return this.upsert;
        }
    }

    public static class AbortCCJobsFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final CcId ccId;

        public AbortCCJobsFunction(CcId ccId) {
            this.ccId = ccId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.ABORT_ALL_JOBS;
        }

        public CcId getCcId() {
            return this.ccId;
        }
    }

    public static class NodeRegistrationResult
    extends Function {
        private static final long serialVersionUID = 1L;
        private final NodeParameters params;
        private final Exception exception;

        public NodeRegistrationResult(NodeParameters params, Exception exception) {
            this.params = params;
            this.exception = exception;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NODE_REGISTRATION_RESULT;
        }

        public NodeParameters getNodeParameters() {
            return this.params;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ReportResultPartitionWriteCompletionFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final ResultSetId rsId;
        private final int partition;

        public ReportResultPartitionWriteCompletionFunction(JobId jobId, ResultSetId rsId, int partition) {
            this.jobId = jobId;
            this.rsId = rsId;
            this.partition = partition;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REPORT_RESULT_PARTITION_WRITE_COMPLETION;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public ResultSetId getResultSetId() {
            return this.rsId;
        }

        public int getPartition() {
            return this.partition;
        }
    }

    public static class RegisterResultPartitionLocationFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final ResultSetId rsId;
        private final IResultMetadata metadata;
        private final boolean emptyResult;
        private final int partition;
        private final int nPartitions;
        private NetworkAddress networkAddress;

        public RegisterResultPartitionLocationFunction(JobId jobId, ResultSetId rsId, IResultMetadata metadata, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) {
            this.jobId = jobId;
            this.rsId = rsId;
            this.metadata = metadata;
            this.emptyResult = emptyResult;
            this.partition = partition;
            this.nPartitions = nPartitions;
            this.networkAddress = networkAddress;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REGISTER_RESULT_PARTITION_LOCATION;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public ResultSetId getResultSetId() {
            return this.rsId;
        }

        public IResultMetadata getMetadata() {
            return this.metadata;
        }

        public boolean getEmptyResult() {
            return this.emptyResult;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getNPartitions() {
            return this.nPartitions;
        }

        public NetworkAddress getNetworkAddress() {
            return this.networkAddress;
        }
    }

    public static class RegisterPartitionRequestFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final PartitionRequest partitionRequest;

        public RegisterPartitionRequestFunction(PartitionRequest partitionRequest) {
            this.partitionRequest = partitionRequest;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REGISTER_PARTITION_REQUEST;
        }

        public PartitionRequest getPartitionRequest() {
            return this.partitionRequest;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            PartitionId pid = CCNCFunctions.readPartitionId(dis);
            String nodeId = dis.readUTF();
            TaskAttemptId taId = CCNCFunctions.readTaskAttemptId(dis);
            PartitionState state = CCNCFunctions.readPartitionState(dis);
            PartitionRequest pr = new PartitionRequest(pid, nodeId, taId, state);
            return new RegisterPartitionRequestFunction(pr);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            RegisterPartitionRequestFunction fn = (RegisterPartitionRequestFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            PartitionRequest pr = fn.getPartitionRequest();
            CCNCFunctions.writePartitionId(dos, pr.getPartitionId());
            dos.writeUTF(pr.getNodeId());
            CCNCFunctions.writeTaskAttemptId(dos, pr.getRequestingTaskAttemptId());
            CCNCFunctions.writePartitionState(dos, pr.getMinimumState());
        }
    }

    public static class RegisterPartitionProviderFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final PartitionDescriptor partitionDescriptor;

        public RegisterPartitionProviderFunction(PartitionDescriptor partitionDescriptor) {
            this.partitionDescriptor = partitionDescriptor;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REGISTER_PARTITION_PROVIDER;
        }

        public PartitionDescriptor getPartitionDescriptor() {
            return this.partitionDescriptor;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            PartitionId pid = CCNCFunctions.readPartitionId(dis);
            String nodeId = dis.readUTF();
            TaskAttemptId taId = CCNCFunctions.readTaskAttemptId(dis);
            boolean reusable = dis.readBoolean();
            PartitionState state = CCNCFunctions.readPartitionState(dis);
            PartitionDescriptor pd = new PartitionDescriptor(pid, nodeId, taId, reusable);
            pd.setState(state);
            return new RegisterPartitionProviderFunction(pd);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            RegisterPartitionProviderFunction fn = (RegisterPartitionProviderFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            PartitionDescriptor pd = fn.getPartitionDescriptor();
            CCNCFunctions.writePartitionId(dos, pd.getPartitionId());
            dos.writeUTF(pd.getNodeId());
            CCNCFunctions.writeTaskAttemptId(dos, pd.getProducingTaskAttemptId());
            dos.writeBoolean(pd.isReusable());
            CCNCFunctions.writePartitionState(dos, pd.getState());
        }
    }

    public static class ReportProfileFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;
        private final List<JobProfile> profiles;

        public ReportProfileFunction(String nodeId, List<JobProfile> profiles) {
            this.nodeId = nodeId;
            this.profiles = profiles;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REPORT_PROFILE;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public List<JobProfile> getProfiles() {
            return this.profiles;
        }
    }

    public static class NodeHeartbeatFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;
        private final HeartbeatData hbData;
        private final InetSocketAddress ncAddress;

        public NodeHeartbeatFunction(String nodeId, HeartbeatData hbData, InetSocketAddress ncAddress) {
            this.nodeId = nodeId;
            this.hbData = hbData;
            this.ncAddress = ncAddress;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NODE_HEARTBEAT;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public HeartbeatData getHeartbeatData() {
            return this.hbData;
        }

        public InetSocketAddress getNcAddress() {
            return this.ncAddress;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            ObjectInputStream dis = new ObjectInputStream(bais);
            HeartbeatData hbData = new HeartbeatData();
            hbData.readFields(dis);
            String nodeId = dis.readUTF();
            InetSocketAddress ncAddress = (InetSocketAddress)dis.readObject();
            return new NodeHeartbeatFunction(nodeId, hbData, ncAddress);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            NodeHeartbeatFunction fn = (NodeHeartbeatFunction)object;
            ObjectOutputStream dos = new ObjectOutputStream(out);
            fn.hbData.write(dos);
            dos.writeUTF(fn.nodeId);
            dos.writeObject(fn.ncAddress);
        }
    }

    public static class NotifyJobletCleanupFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final String nodeId;

        public NotifyJobletCleanupFunction(JobId jobId, String nodeId) {
            this.jobId = jobId;
            this.nodeId = nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NOTIFY_JOBLET_CLEANUP;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            JobId jobId = JobId.create((DataInput)dis);
            String nodeId = dis.readUTF();
            return new NotifyJobletCleanupFunction(jobId, nodeId);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            NotifyJobletCleanupFunction fn = (NotifyJobletCleanupFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            fn.jobId.writeFields((DataOutput)dos);
            dos.writeUTF(fn.nodeId);
        }
    }

    public static class ReportDeployedJobSpecFailureFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final DeployedJobSpecId deployedJobSpecId;
        private final String nodeId;

        public ReportDeployedJobSpecFailureFunction(DeployedJobSpecId deployedJobSpecId, String nodeId) {
            this.deployedJobSpecId = deployedJobSpecId;
            this.nodeId = nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.DEPLOYED_JOB_FAILURE;
        }

        public DeployedJobSpecId getDeployedJobSpecId() {
            return this.deployedJobSpecId;
        }

        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class NotifyTaskFailureFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final JobId jobId;
        private final TaskAttemptId taskId;
        private final String nodeId;
        private final List<Exception> exceptions;

        public NotifyTaskFailureFunction(JobId jobId, TaskAttemptId taskId, String nodeId, List<Exception> exceptions) {
            this.jobId = jobId;
            this.taskId = taskId;
            this.nodeId = nodeId;
            this.exceptions = exceptions;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NOTIFY_TASK_FAILURE;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public TaskAttemptId getTaskId() {
            return this.taskId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }
    }

    public static class NotifyTaskCompleteFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private JobId jobId;
        private TaskAttemptId taskId;
        private String nodeId;
        private TaskProfile statistics;

        public NotifyTaskCompleteFunction(JobId jobId, TaskAttemptId taskId, String nodeId, TaskProfile statistics) {
            this.jobId = jobId;
            this.taskId = taskId;
            this.nodeId = nodeId;
            this.statistics = statistics;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.NOTIFY_TASK_COMPLETE;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public TaskAttemptId getTaskId() {
            return this.taskId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskProfile getStatistics() {
            return this.statistics;
        }

        public static Object deserialize(ByteBuffer buffer, int length) throws Exception {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            DataInputStream dis = new DataInputStream(bais);
            JobId jobId = JobId.create((DataInput)dis);
            String nodeId = dis.readUTF();
            TaskAttemptId taskId = TaskAttemptId.create((DataInput)dis);
            TaskProfile statistics = TaskProfile.create(dis);
            return new NotifyTaskCompleteFunction(jobId, taskId, nodeId, statistics);
        }

        public static void serialize(OutputStream out, Object object) throws Exception {
            NotifyTaskCompleteFunction fn = (NotifyTaskCompleteFunction)object;
            DataOutputStream dos = new DataOutputStream(out);
            fn.jobId.writeFields((DataOutput)dos);
            dos.writeUTF(fn.nodeId);
            fn.taskId.writeFields((DataOutput)dos);
            fn.statistics.writeFields(dos);
        }
    }

    public static class UnregisterNodeFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final String nodeId;

        public UnregisterNodeFunction(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.UNREGISTER_NODE;
        }

        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class RegisterNodeFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final NodeRegistration reg;
        private final int registrationId;

        public RegisterNodeFunction(NodeRegistration reg, int registrationId) {
            this.reg = reg;
            this.registrationId = registrationId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.REGISTER_NODE;
        }

        public NodeRegistration getNodeRegistration() {
            return this.reg;
        }

        public int getRegistrationId() {
            return this.registrationId;
        }
    }

    public static abstract class CCIdentifiedFunction
    extends Function {
        private static final long serialVersionUID = 1L;
        private final CcId ccId;

        protected CCIdentifiedFunction(CcId ccId) {
            this.ccId = ccId;
        }

        public CcId getCcId() {
            return this.ccId;
        }
    }

    public static abstract class Function
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public abstract FunctionId getFunctionId();
    }

    public static class SendApplicationMessageFunction
    extends Function {
        private static final long serialVersionUID = 2L;
        private final byte[] serializedMessage;
        private final DeploymentId deploymentId;
        private final boolean realTime;
        private String nodeId;

        public DeploymentId getDeploymentId() {
            return this.deploymentId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public byte[] getMessage() {
            return this.serializedMessage;
        }

        public boolean isRealTime() {
            return this.realTime;
        }

        public SendApplicationMessageFunction(byte[] data, DeploymentId deploymentId, boolean realTime, String nodeId) {
            this.serializedMessage = data;
            this.deploymentId = deploymentId;
            this.realTime = realTime;
            this.nodeId = nodeId;
        }

        @Override
        public FunctionId getFunctionId() {
            return FunctionId.SEND_APPLICATION_MESSAGE;
        }
    }

    public static enum FunctionId {
        REGISTER_NODE,
        UNREGISTER_NODE,
        NOTIFY_JOBLET_CLEANUP,
        NOTIFY_TASK_COMPLETE,
        NOTIFY_TASK_FAILURE,
        NODE_HEARTBEAT,
        NODE_HEARTBEAT_ACK,
        REPORT_PROFILE,
        REGISTER_PARTITION_PROVIDER,
        REGISTER_PARTITION_REQUEST,
        REGISTER_RESULT_PARTITION_LOCATION,
        REPORT_RESULT_PARTITION_WRITE_COMPLETION,
        NODE_REGISTRATION_RESULT,
        START_TASKS,
        ABORT_TASKS,
        ABORT_ALL_JOBS,
        CLEANUP_JOBLET,
        REPORT_PARTITION_AVAILABILITY,
        SEND_APPLICATION_MESSAGE,
        GET_NODE_CONTROLLERS_INFO,
        GET_NODE_CONTROLLERS_INFO_RESPONSE,
        DEPLOY_BINARY,
        NOTIFY_DEPLOY_BINARY,
        UNDEPLOY_BINARY,
        SHUTDOWN_REQUEST,
        SHUTDOWN_RESPONSE,
        DEPLOY_JOB,
        UNDEPLOY_JOB,
        DEPLOYED_JOB_FAILURE,
        STATE_DUMP_REQUEST,
        STATE_DUMP_RESPONSE,
        THREAD_DUMP_REQUEST,
        THREAD_DUMP_RESPONSE,
        PING_REQUEST,
        PING_RESPONSE,
        OTHER;

    }
}

