/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import rx.Observable;
import rx.Subscription;
import rx.annotations.Beta;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.internal.operators.OnSubscribeAutoConnect;
import rx.internal.operators.OnSubscribeRefCount;

public abstract class ConnectableObservable<T>
extends Observable<T> {
    protected ConnectableObservable(Observable.OnSubscribe<T> onSubscribe) {
        super(onSubscribe);
    }

    public final Subscription connect() {
        final Subscription[] out = new Subscription[1];
        this.connect((Action1<Subscription>)new Action1<Subscription>(){

            @Override
            public void call(Subscription t1) {
                out[0] = t1;
            }
        });
        return out[0];
    }

    public abstract void connect(Action1<? super Subscription> var1);

    public Observable<T> refCount() {
        return ConnectableObservable.create(new OnSubscribeRefCount(this));
    }

    @Beta
    public Observable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @Beta
    public Observable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Actions.empty());
    }

    @Beta
    public Observable<T> autoConnect(int numberOfSubscribers, Action1<? super Subscription> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return this;
        }
        return ConnectableObservable.create(new OnSubscribeAutoConnect(this, numberOfSubscribers, connection));
    }
}

