/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ConsolidateWindowOperatorsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        WindowOperator winOp1 = (WindowOperator)op1;
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        WindowOperator winOp2 = (WindowOperator)op2;
        if (!IsomorphismOperatorVisitor.compareWindowPartitionSpec((WindowOperator)winOp1, (WindowOperator)winOp2)) {
            return false;
        }
        if (winOp1.hasNestedPlans() && winOp2.hasNestedPlans() && !IsomorphismOperatorVisitor.compareWindowFrameSpecExcludingMaxObjects((WindowOperator)winOp1, (WindowOperator)winOp2)) {
            return false;
        }
        HashSet used1 = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)winOp1, used1);
        if (!OperatorPropertiesUtil.disjoint((Collection)winOp2.getVariables(), used1)) {
            return false;
        }
        if (winOp2.hasNestedPlans() && !this.consolidateNestedPlans(winOp1, winOp2, context)) {
            return false;
        }
        winOp1.getVariables().addAll(winOp2.getVariables());
        winOp1.getExpressions().addAll(winOp2.getExpressions());
        winOp1.getInputs().clear();
        winOp1.getInputs().addAll(winOp2.getInputs());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)winOp1);
        return true;
    }

    private boolean consolidateNestedPlans(WindowOperator winOpTo, WindowOperator winOpFrom, IOptimizationContext context) throws AlgebricksException {
        if (winOpTo.hasNestedPlans()) {
            int winOpFromMaxObjects;
            AggregateOperator aggTo = this.getAggregateRoot(winOpTo.getNestedPlans());
            if (aggTo == null) {
                return false;
            }
            AggregateOperator aggFrom = this.getAggregateRoot(winOpFrom.getNestedPlans());
            if (aggFrom == null) {
                return false;
            }
            if (!IsomorphismUtilities.isOperatorIsomorphicPlanSegment((ILogicalOperator)((ILogicalOperator)((Mutable)aggTo.getInputs().get(0)).getValue()), (ILogicalOperator)((ILogicalOperator)((Mutable)aggFrom.getInputs().get(0)).getValue()))) {
                return false;
            }
            int winOpToMaxObjects = winOpTo.getFrameMaxObjects();
            if (winOpToMaxObjects != (winOpFromMaxObjects = winOpFrom.getFrameMaxObjects())) {
                if (this.subsumeFrameMaxObjects(winOpFromMaxObjects, winOpToMaxObjects, aggTo)) {
                    winOpToMaxObjects = winOpFromMaxObjects;
                } else if (!this.subsumeFrameMaxObjects(winOpToMaxObjects, winOpFromMaxObjects, aggFrom)) {
                    return false;
                }
            }
            winOpTo.setFrameMaxObjects(winOpToMaxObjects);
            aggTo.getVariables().addAll(aggFrom.getVariables());
            aggTo.getExpressions().addAll(aggFrom.getExpressions());
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggTo);
        } else {
            this.setAll(winOpTo.getNestedPlans(), winOpFrom.getNestedPlans());
            this.setAll(winOpTo.getFrameValueExpressions(), winOpFrom.getFrameValueExpressions());
            this.setAll(winOpTo.getFrameStartExpressions(), winOpFrom.getFrameStartExpressions());
            this.setAll(winOpTo.getFrameStartValidationExpressions(), winOpFrom.getFrameStartValidationExpressions());
            this.setAll(winOpTo.getFrameEndExpressions(), winOpFrom.getFrameEndExpressions());
            this.setAll(winOpTo.getFrameEndValidationExpressions(), winOpFrom.getFrameEndValidationExpressions());
            this.setAll(winOpTo.getFrameExcludeExpressions(), winOpFrom.getFrameExcludeExpressions());
            winOpTo.setFrameExcludeNegationStartIdx(winOpFrom.getFrameExcludeNegationStartIdx());
            winOpTo.getFrameExcludeUnaryExpression().setValue((Object)((ILogicalExpression)winOpFrom.getFrameExcludeUnaryExpression().getValue()));
            winOpTo.getFrameOffsetExpression().setValue((Object)((ILogicalExpression)winOpFrom.getFrameOffsetExpression().getValue()));
            winOpTo.setFrameMaxObjects(winOpFrom.getFrameMaxObjects());
        }
        return true;
    }

    private AggregateOperator getAggregateRoot(List<ILogicalPlan> nestedPlans) {
        if (nestedPlans.size() != 1) {
            return null;
        }
        List roots = nestedPlans.get(0).getRoots();
        if (roots.size() != 1) {
            return null;
        }
        ILogicalOperator rootOp = (ILogicalOperator)((Mutable)roots.get(0)).getValue();
        if (rootOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return null;
        }
        return (AggregateOperator)rootOp;
    }

    private <T> void setAll(Collection<? super T> to, Collection<? extends T> from) {
        if (!to.isEmpty()) {
            throw new IllegalStateException(String.valueOf(to.size()));
        }
        to.addAll(from);
    }

    protected boolean subsumeFrameMaxObjects(int maxObjects1, int maxObjects2, AggregateOperator aggOp2) {
        return false;
    }
}

