/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.util.Map;
import org.apache.hyracks.api.client.HyracksClientInterfaceFunctions;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.DeployedJobSpecIdFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobIdFactory;
import org.apache.hyracks.api.job.JobInfo;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.ResultDirectoryRecord;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.CancelJobWork;
import org.apache.hyracks.control.cc.work.CliDeployBinaryWork;
import org.apache.hyracks.control.cc.work.CliUnDeployBinaryWork;
import org.apache.hyracks.control.cc.work.ClusterShutdownWork;
import org.apache.hyracks.control.cc.work.DeployJobSpecWork;
import org.apache.hyracks.control.cc.work.GetJobInfoWork;
import org.apache.hyracks.control.cc.work.GetJobStatusWork;
import org.apache.hyracks.control.cc.work.GetNodeControllersInfoWork;
import org.apache.hyracks.control.cc.work.GetNodeDetailsJSONWork;
import org.apache.hyracks.control.cc.work.GetResultDirectoryAddressWork;
import org.apache.hyracks.control.cc.work.GetResultMetadataWork;
import org.apache.hyracks.control.cc.work.GetResultPartitionLocationsWork;
import org.apache.hyracks.control.cc.work.GetResultStatusWork;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.cc.work.JobStartWork;
import org.apache.hyracks.control.cc.work.UndeployJobSpecWork;
import org.apache.hyracks.control.cc.work.WaitForJobCompletionWork;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ClientInterfaceIPCI
implements IIPCI {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final JobIdFactory jobIdFactory;
    private final DeployedJobSpecIdFactory deployedJobSpecIdFactory;

    ClientInterfaceIPCI(ClusterControllerService ccs, JobIdFactory jobIdFactory) {
        this.ccs = ccs;
        this.jobIdFactory = jobIdFactory;
        this.deployedJobSpecIdFactory = ccs.getDeployedJobSpecIdFactory();
    }

    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload) {
        HyracksClientInterfaceFunctions.Function fn = (HyracksClientInterfaceFunctions.Function)payload;
        switch (fn.getFunctionId()) {
            case GET_CLUSTER_CONTROLLER_INFO: {
                try {
                    handle.send(mid, (Object)this.ccs.getClusterControllerInfo(), null);
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARN, "Error sending response to GET_CLUSTER_CONTROLLER_INFO request", (Throwable)e);
                }
                break;
            }
            case GET_JOB_STATUS: {
                HyracksClientInterfaceFunctions.GetJobStatusFunction gjsf = (HyracksClientInterfaceFunctions.GetJobStatusFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetJobStatusWork(this.ccs.getJobManager(), gjsf.getJobId(), (IResultCallback<JobStatus>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_JOB_INFO: {
                HyracksClientInterfaceFunctions.GetJobInfoFunction gjif = (HyracksClientInterfaceFunctions.GetJobInfoFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetJobInfoWork(this.ccs.getJobManager(), gjif.getJobId(), (IResultCallback<JobInfo>)new IPCResponder(handle, mid)));
                break;
            }
            case DEPLOY_JOB: {
                HyracksClientInterfaceFunctions.DeployJobSpecFunction djf = (HyracksClientInterfaceFunctions.DeployJobSpecFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new DeployJobSpecWork(this.ccs, djf.getACGGFBytes(), this.deployedJobSpecIdFactory.create(), false, (IResultCallback<DeployedJobSpecId>)new IPCResponder(handle, mid)));
                break;
            }
            case REDEPLOY_JOB: {
                HyracksClientInterfaceFunctions.redeployJobSpecFunction udjsf = (HyracksClientInterfaceFunctions.redeployJobSpecFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new DeployJobSpecWork(this.ccs, udjsf.getACGGFBytes(), udjsf.getDeployedJobSpecId(), true, (IResultCallback<DeployedJobSpecId>)new IPCResponder(handle, mid)));
                break;
            }
            case UNDEPLOY_JOB: {
                HyracksClientInterfaceFunctions.UndeployJobSpecFunction dsjf = (HyracksClientInterfaceFunctions.UndeployJobSpecFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new UndeployJobSpecWork(this.ccs, dsjf.getDeployedJobSpecId(), (IResultCallback<Void>)new IPCResponder(handle, mid)));
                break;
            }
            case CANCEL_JOB: {
                HyracksClientInterfaceFunctions.CancelJobFunction cjf = (HyracksClientInterfaceFunctions.CancelJobFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CancelJobWork(this.ccs.getJobManager(), cjf.getJobId(), (IResultCallback<Void>)new IPCResponder(handle, mid)));
                break;
            }
            case START_JOB: {
                HyracksClientInterfaceFunctions.StartJobFunction sjf = (HyracksClientInterfaceFunctions.StartJobFunction)fn;
                DeployedJobSpecId id = sjf.getDeployedJobSpecId();
                byte[] acggfBytes = null;
                if (id == null) {
                    acggfBytes = sjf.getACGGFBytes();
                }
                this.ccs.getWorkQueue().schedule((AbstractWork)new JobStartWork(this.ccs, sjf.getDeploymentId(), acggfBytes, sjf.getJobFlags(), this.jobIdFactory, sjf.getJobParameters(), (IResultCallback<JobId>)new IPCResponder(handle, mid), id));
                break;
            }
            case GET_RESULT_DIRECTORY_ADDRESS: {
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultDirectoryAddressWork(this.ccs, (IResultCallback<NetworkAddress>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_RESULT_STATUS: {
                HyracksClientInterfaceFunctions.GetResultStatusFunction gdrsf = (HyracksClientInterfaceFunctions.GetResultStatusFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultStatusWork(this.ccs, gdrsf.getJobId(), gdrsf.getResultSetId(), (IResultCallback<ResultJobRecord.Status>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_RESULT_LOCATIONS: {
                HyracksClientInterfaceFunctions.GetResultLocationsFunction gdrlf = (HyracksClientInterfaceFunctions.GetResultLocationsFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultPartitionLocationsWork(this.ccs, gdrlf.getJobId(), gdrlf.getResultSetId(), gdrlf.getKnownRecords(), (IResultCallback<ResultDirectoryRecord[]>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_RESULT_METADATA: {
                HyracksClientInterfaceFunctions.GetResultMetadataFunction grmf = (HyracksClientInterfaceFunctions.GetResultMetadataFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultMetadataWork(this.ccs, grmf.getJobId(), grmf.getResultSetId(), (IResultCallback<IResultMetadata>)new IPCResponder(handle, mid)));
                break;
            }
            case WAIT_FOR_COMPLETION: {
                HyracksClientInterfaceFunctions.WaitForCompletionFunction wfcf = (HyracksClientInterfaceFunctions.WaitForCompletionFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new WaitForJobCompletionWork(this.ccs, wfcf.getJobId(), (IResultCallback<Object>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_NODE_CONTROLLERS_INFO: {
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetNodeControllersInfoWork(this.ccs.getNodeManager(), (IResultCallback<Map<String, NodeControllerInfo>>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_CLUSTER_TOPOLOGY: {
                try {
                    handle.send(mid, (Object)this.ccs.getCCContext().getClusterTopology(), null);
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARN, "Error sending response to GET_CLUSTER_TOPOLOGY request", (Throwable)e);
                }
                break;
            }
            case CLI_DEPLOY_BINARY: {
                HyracksClientInterfaceFunctions.CliDeployBinaryFunction dbf = (HyracksClientInterfaceFunctions.CliDeployBinaryFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CliDeployBinaryWork(this.ccs, dbf.getBinaryURLs(), dbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                break;
            }
            case CLI_UNDEPLOY_BINARY: {
                HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction udbf = (HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CliUnDeployBinaryWork(this.ccs, udbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                break;
            }
            case CLUSTER_SHUTDOWN: {
                HyracksClientInterfaceFunctions.ClusterShutdownFunction csf = (HyracksClientInterfaceFunctions.ClusterShutdownFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new ClusterShutdownWork(this.ccs, csf.isTerminateNCService(), (IResultCallback<Boolean>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_NODE_DETAILS_JSON: {
                HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction gndjf = (HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetNodeDetailsJSONWork(this.ccs.getNodeManager(), this.ccs.getCCConfig(), gndjf.getNodeId(), gndjf.isIncludeStats(), gndjf.isIncludeConfig(), (IPCResponder<String>)new IPCResponder(handle, mid)));
                break;
            }
            case THREAD_DUMP: {
                HyracksClientInterfaceFunctions.ThreadDumpFunction tdf = (HyracksClientInterfaceFunctions.ThreadDumpFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetThreadDumpWork(this.ccs, tdf.getNode(), (IResultCallback<String>)new IPCResponder(handle, mid)));
                break;
            }
            default: {
                try {
                    handle.send(mid, null, (Exception)new IllegalArgumentException("Unknown function " + fn.getFunctionId()));
                    break;
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARN, "Error sending Unknown function response", (Throwable)e);
                }
            }
        }
    }

    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        LOGGER.info("exception in/or processing message", (Throwable)exception);
        try {
            handle.send(mid, null, exception);
        }
        catch (IPCException e) {
            LOGGER.warn("error sending exception response", (Throwable)e);
        }
    }
}

