/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.ServiceConstants;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class TriggerNCWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String JVM_ARG_MAX_GCPAUSE_MILLIS = "-XX:MaxGCPauseMillis=";
    private final ClusterControllerService ccs;
    private final String ncHost;
    private final int ncPort;
    private final String ncId;

    public TriggerNCWork(ClusterControllerService ccs, String ncHost, int ncPort, String ncId) {
        this.ccs = ccs;
        this.ncHost = ncHost;
        this.ncPort = ncPort;
        this.ncId = ncId;
    }

    public final void run() {
        this.ccs.getExecutor().execute(() -> {
            while (true) {
                LOGGER.info("Connecting NC service '" + this.ncId + "' at " + this.ncHost + ":" + this.ncPort);
                try (Socket s = new Socket(this.ncHost, this.ncPort);){
                    ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                    oos.writeUTF("hyncmagic2");
                    oos.writeUTF(ServiceConstants.ServiceCommand.START_NC.name());
                    oos.writeUTF(this.serializeIni());
                    oos.close();
                    return;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARN, "Failed to contact NC service at " + this.ncHost + ":" + this.ncPort + "; will retry", (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
            }
        });
    }

    private String serializeIni() throws IOException {
        StringWriter iniString = new StringWriter();
        ConfigManager configManager = this.ccs.getCCConfig().getConfigManager();
        Ini ccini = configManager.toIni(false);
        IApplicationConfig ncConfig = configManager.getNodeEffectiveConfig(this.ncId);
        Profile.Section ncSection = this.getNcSection(ccini);
        this.configClusterAddress(ncConfig, ncSection);
        this.configMaxGcPause(ncConfig, ncSection);
        ccini.put(Section.LOCALNC.sectionName(), NCConfig.Option.NODE_ID.ini(), (Object)this.ncId);
        ccini.store((Writer)iniString);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Returning Ini file:\n" + iniString.toString());
        }
        return iniString.toString();
    }

    private Profile.Section getNcSection(Ini ccini) {
        String sectionName = Section.NC.sectionName() + "/" + this.ncId;
        Profile.Section ncSection = (Profile.Section)ccini.get((Object)sectionName);
        if (ncSection == null) {
            ncSection = ccini.add(sectionName);
        }
        return ncSection;
    }

    private void configClusterAddress(IApplicationConfig ncConfig, Profile.Section ncSection) {
        if (ncConfig.getString((IOption)NCConfig.Option.CLUSTER_ADDRESS) == null) {
            ncSection.put((Object)NCConfig.Option.CLUSTER_ADDRESS.ini(), (Object)this.ccs.getCCConfig().getClusterPublicAddress());
            ncSection.put((Object)NCConfig.Option.CLUSTER_PORT.ini(), (Object)String.valueOf(this.ccs.getCCConfig().getClusterPublicPort()));
        }
    }

    private void configMaxGcPause(IApplicationConfig ncConfig, Profile.Section ncSection) {
        String ncJvmArgs = ncConfig.getString((IOption)NCConfig.Option.JVM_ARGS);
        if (ncJvmArgs == null || !ncJvmArgs.contains(JVM_ARG_MAX_GCPAUSE_MILLIS)) {
            String gcMaxPauseArg = JVM_ARG_MAX_GCPAUSE_MILLIS + this.getGcMaxPauseMillis();
            ncSection.put((Object)NCConfig.Option.JVM_ARGS.ini(), (Object)(ncJvmArgs == null ? gcMaxPauseArg : ncJvmArgs + " " + gcMaxPauseArg));
        }
    }

    private long getGcMaxPauseMillis() {
        return this.ccs.getCCConfig().getHeartbeatPeriodMillis() * (long)this.ccs.getCCConfig().getHeartbeatMaxMisses() / 2L;
    }
}

