/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ArrayRepeatDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private AbstractCollectionType repeatedValueListType;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayRepeatDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENTS_TYPE;
        }
    };

    public void setImmutableStates(Object ... states) {
        this.repeatedValueListType = new AOrderedListType((IAType)states[0], null);
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_REPEAT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayRepeatEval(args, ctx);
            }
        };
    }

    public class ArrayRepeatEval
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final IScalarEvaluator repeatedValueEval;
        private final IScalarEvaluator repeatEval;
        private final IPointable repeatedValueArg;
        private final IPointable repeatArg;
        private final TaggedValuePointable repeatArgValue;
        private final IAsterixListBuilder listBuilder;

        public ArrayRepeatEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.repeatedValueEval = args[0].createScalarEvaluator(ctx);
            this.repeatEval = args[1].createScalarEvaluator(ctx);
            this.repeatedValueArg = new VoidPointable();
            this.repeatArg = new VoidPointable();
            this.repeatArgValue = new TaggedValuePointable();
            this.listBuilder = new OrderedListBuilder();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.repeatedValueEval.evaluate(tuple, this.repeatedValueArg);
            this.repeatEval.evaluate(tuple, this.repeatArg);
            if (PointableHelper.checkAndSetMissingOrNull(result, this.repeatedValueArg, this.repeatArg)) {
                return;
            }
            this.repeatArgValue.set((IValueReference)this.repeatArg);
            if (!ATypeHierarchy.isCompatible((ATypeTag)ATypeTag.DOUBLE, (ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[this.repeatArgValue.getTag()])) {
                PointableHelper.setNull(result);
                return;
            }
            String name = ArrayRepeatDescriptor.this.getIdentifier().getName();
            double repetitions = ATypeHierarchy.getDoubleValue((String)name, (int)1, (byte[])this.repeatArg.getByteArray(), (int)this.repeatArg.getStartOffset());
            if (Double.isNaN(repetitions) || Double.isInfinite(repetitions) || Math.floor(repetitions) < repetitions || repetitions < 0.0) {
                PointableHelper.setNull(result);
                return;
            }
            this.listBuilder.reset(ArrayRepeatDescriptor.this.repeatedValueListType);
            int i = 0;
            while ((double)i < repetitions) {
                this.listBuilder.addItem((IValueReference)this.repeatedValueArg);
                ++i;
            }
            this.storage.reset();
            this.listBuilder.write(this.storage.getDataOutput(), true);
            result.set((IValueReference)this.storage);
        }
    }
}

