/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.runningaggregates.base.AbstractRunningAggregateFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class CreateQueryUIDDescriptor
extends AbstractRunningAggregateFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = CreateQueryUIDDescriptor::new;

    public IRunningAggregateEvaluatorFactory createRunningAggregateEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new IRunningAggregateEvaluatorFactory(){
            private static final long serialVersionUID = 1L;
            private static final int BINARY_LENGTH = 14;
            private static final int PAYLOAD_START = 2;

            public IRunningAggregateEvaluator createRunningAggregateEvaluator(IEvaluatorContext ctx) {
                final byte[] uidBytes = new byte[14];
                uidBytes[0] = ATypeTag.SERIALIZED_BINARY_TYPE_TAG;
                uidBytes[1] = 12;
                IntegerPointable.setInteger((byte[])uidBytes, (int)2, (int)ctx.getTaskContext().getTaskAttemptId().getTaskId().getPartition());
                return new IRunningAggregateEvaluator(){

                    public void init() {
                    }

                    public void step(IFrameTupleReference tuple, IPointable result) {
                        int i = 13;
                        while (i >= 2) {
                            int n = i--;
                            uidBytes[n] = (byte)(uidBytes[n] + 1);
                            if (uidBytes[n] != 0) break;
                        }
                        result.set(uidBytes, 0, 14);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CREATE_QUERY_UID;
    }
}

