/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import java.io.IOException;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ListAccessorUtil {
    private ListAccessorUtil() {
    }

    public static boolean getItem(byte[] listBytes, int start, int itemIndex, ATypeTag listTag, ATypeTag listItemTag, IPointable pointable, ArrayBackedValueStorage storage) throws IOException {
        int itemOffset;
        if (listTag == ATypeTag.MULTISET) {
            itemOffset = AUnorderedListSerializerDeserializer.getItemOffset(listBytes, start, itemIndex);
        } else if (listTag == ATypeTag.ARRAY) {
            itemOffset = AOrderedListSerializerDeserializer.getItemOffset(listBytes, start, itemIndex);
        } else {
            throw new IllegalStateException();
        }
        boolean itemIncludesTag = listItemTag == ATypeTag.ANY;
        ATypeTag itemTag = itemIncludesTag ? EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[itemOffset]) : listItemTag;
        int itemValueLength = NonTaggedFormatUtil.getFieldValueLength(listBytes, itemOffset, itemTag, itemIncludesTag);
        if (itemIncludesTag) {
            pointable.set(listBytes, itemOffset, itemValueLength + 1);
            return false;
        }
        storage.reset();
        storage.getDataOutput().writeByte(listItemTag.serialize());
        storage.getDataOutput().write(listBytes, itemOffset, itemValueLength);
        pointable.set((IValueReference)storage);
        return true;
    }

    public static void getItemFromList(TaggedValueReference listValue, int itemIndex, TaggedValueReference item, ATypeTag arrayItemTag, boolean itemHasTag) throws IOException {
        int itemOffset = SerializerDeserializerUtil.getItemOffsetNonTagged(listValue, itemIndex);
        ListAccessorUtil.getItem(listValue, itemOffset, item, arrayItemTag, itemHasTag);
    }

    private static void getItem(TaggedValueReference listValue, int itemOffset, TaggedValueReference item, ATypeTag listItemTag, boolean itemHasTag) throws IOException {
        ATypeTag itemTag;
        byte[] listBytes = listValue.getByteArray();
        int itemValueOffset = itemOffset;
        if (itemHasTag) {
            itemTag = ATypeTag.VALUE_TYPE_MAPPING[listBytes[itemOffset]];
            itemValueOffset = itemOffset + 1;
        } else {
            itemTag = listItemTag;
        }
        int itemValueLength = NonTaggedFormatUtil.getFieldValueLength(listBytes, itemOffset, itemTag, itemHasTag);
        item.set(listBytes, itemValueOffset, itemValueLength, itemTag);
    }
}

