/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class OrderedLinearizeComparatorFactory
implements ILinearizeComparatorFactory {
    private static final long serialVersionUID = 1L;
    private final boolean ascending;
    private final IBinaryComparatorFactory factory;

    public OrderedLinearizeComparatorFactory(IBinaryComparatorFactory factory, boolean ascending) {
        this.factory = factory;
        this.ascending = ascending;
    }

    public ILinearizeComparator createBinaryComparator() {
        final ILinearizeComparator bc = (ILinearizeComparator)this.factory.createBinaryComparator();
        final int dimension = bc.getDimensions();
        if (this.ascending) {
            return new ILinearizeComparator(){

                public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                    return bc.compare(b1, s1 + 1, l1, b2, s2 + 1, l2);
                }

                public int getDimensions() {
                    return dimension;
                }
            };
        }
        return new ILinearizeComparator(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                return -bc.compare(b1, s1 + 1, l1, b2, s2 + 1, l2);
            }

            public int getDimensions() {
                return dimension;
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("factory", this.factory.toJson(registry));
        json.put("ascending", this.ascending);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        IBinaryComparatorFactory factory = (IBinaryComparatorFactory)registry.deserialize(json.get("factory"));
        return new OrderedLinearizeComparatorFactory(factory, json.get("ascending").asBoolean());
    }
}

