/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class ADateParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new ADateParserFactory();
    private static final long serialVersionUID = 1L;
    private static final String dateErrorMessage = "Wrong input format for a date value";

    private ADateParserFactory() {
    }

    public IValueParser createValueParser() {
        return new IValueParser(){

            public boolean parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                try {
                    out.writeInt((int)(ADateParserFactory.parseDatePart(buffer, start, length) / 86400000L));
                    return true;
                }
                catch (IOException ex) {
                    throw HyracksDataException.create((Throwable)ex);
                }
            }
        };
    }

    public static long parseDatePart(String dateString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        boolean positive = true;
        boolean isExtendedForm = false;
        if (dateString.charAt(start + offset) == '-') {
            ++offset;
            positive = false;
        }
        if (dateString.charAt(start + offset + 4) == '-') {
            isExtendedForm = true;
        }
        if (isExtendedForm && (dateString.charAt(start + offset + 4) != '-' || dateString.charAt(start + offset + 7) != '-')) {
            throw new HyracksDataException("Missing dash in the date string as an extended form");
        }
        for (i = 0; i < 4; ++i) {
            if (dateString.charAt(start + offset + i) < '0' || dateString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Non-numeric value in year field");
            }
            year = year * 10 + dateString.charAt(start + offset + i) - 48;
        }
        if (year < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.YEAR.ordinal()] || year > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.YEAR.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: year " + year);
        }
        offset += isExtendedForm ? 5 : 4;
        for (i = 0; i < 2; ++i) {
            if (dateString.charAt(start + offset + i) < '0' || dateString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Non-numeric value in month field");
            }
            month = month * 10 + dateString.charAt(start + offset + i) - 48;
        }
        if (month < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MONTH.ordinal()] || month > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MONTH.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: month " + month);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (dateString.charAt(start + offset + i) < '0' || dateString.charAt(start + offset + i) > '9') {
                throw new HyracksDataException("Non-numeric value in day field");
            }
            day = day * 10 + dateString.charAt(start + offset + i) - 48;
        }
        if (day < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()] || day > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.DAY.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: day " + day);
        }
        offset += 2;
        if (!positive) {
            year *= -1;
        }
        if (length > offset) {
            throw new HyracksDataException("Too many chars for a date only value");
        }
        if (!GregorianCalendarSystem.getInstance().validate(year, month, day, 0, 0, 0, 0)) {
            throw new HyracksDataException(dateErrorMessage);
        }
        return GregorianCalendarSystem.getInstance().getChronon(year, month, day, 0, 0, 0, 0, 0);
    }

    public static long parseDatePart(char[] dateString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        boolean positive = true;
        boolean isExtendedForm = false;
        if (dateString[start + offset] == '-') {
            ++offset;
            positive = false;
        }
        if (dateString[start + offset + 4] == '-') {
            isExtendedForm = true;
        }
        if (isExtendedForm && (dateString[start + offset + 4] != '-' || dateString[start + offset + 7] != '-')) {
            throw new HyracksDataException("Missing dash in the date string as an extended form");
        }
        for (i = 0; i < 4; ++i) {
            if (dateString[start + offset + i] < '0' || dateString[start + offset + i] > '9') {
                throw new HyracksDataException("Non-numeric value in year field");
            }
            year = year * 10 + dateString[start + offset + i] - 48;
        }
        if (year < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.YEAR.ordinal()] || year > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.YEAR.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: year " + year);
        }
        offset += isExtendedForm ? 5 : 4;
        for (i = 0; i < 2; ++i) {
            if (dateString[start + offset + i] < '0' || dateString[start + offset + i] > '9') {
                throw new HyracksDataException("Non-numeric value in month field");
            }
            month = month * 10 + dateString[start + offset + i] - 48;
        }
        if (month < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MONTH.ordinal()] || month > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MONTH.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: month " + month);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (dateString[start + offset + i] < '0' || dateString[start + offset + i] > '9') {
                throw new HyracksDataException("Non-numeric value in day field");
            }
            day = day * 10 + dateString[start + offset + i] - 48;
        }
        if (day < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()] || day > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.DAY.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: day " + day);
        }
        offset += 2;
        if (!positive) {
            year *= -1;
        }
        if (length > offset) {
            throw new HyracksDataException("Too many chars for a date only value");
        }
        if (!GregorianCalendarSystem.getInstance().validate(year, month, day, 0, 0, 0, 0)) {
            throw new HyracksDataException(dateErrorMessage);
        }
        return GregorianCalendarSystem.getInstance().getChronon(year, month, day, 0, 0, 0, 0, 0);
    }

    public static long parseDatePart(byte[] dateString, int start, int length) throws HyracksDataException {
        int i;
        int offset = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        boolean positive = true;
        boolean isExtendedForm = false;
        if (dateString[start + offset] == 45) {
            ++offset;
            positive = false;
        }
        if (dateString[start + offset + 4] == 45) {
            isExtendedForm = true;
        }
        if (isExtendedForm && (dateString[start + offset + 4] != 45 || dateString[start + offset + 7] != 45)) {
            throw new HyracksDataException("Missing dash in the date string as an extended form");
        }
        for (i = 0; i < 4; ++i) {
            if (dateString[start + offset + i] < 48 || dateString[start + offset + i] > 57) {
                throw new HyracksDataException("Non-numeric value in year field");
            }
            year = year * 10 + dateString[start + offset + i] - 48;
        }
        if (year < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.YEAR.ordinal()] || year > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.YEAR.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: year " + year);
        }
        offset += isExtendedForm ? 5 : 4;
        for (i = 0; i < 2; ++i) {
            if (dateString[start + offset + i] < 48 || dateString[start + offset + i] > 57) {
                throw new HyracksDataException("Non-numeric value in month field");
            }
            month = month * 10 + dateString[start + offset + i] - 48;
        }
        if (month < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MONTH.ordinal()] || month > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.MONTH.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: month " + month);
        }
        offset += isExtendedForm ? 3 : 2;
        for (i = 0; i < 2; ++i) {
            if (dateString[start + offset + i] < 48 || dateString[start + offset + i] > 57) {
                throw new HyracksDataException("Non-numeric value in day field");
            }
            day = day * 10 + dateString[start + offset + i] - 48;
        }
        if (day < GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()] || day > GregorianCalendarSystem.FIELD_MAXS[GregorianCalendarSystem.Fields.DAY.ordinal()]) {
            throw new HyracksDataException("Wrong input format for a date value: day " + day);
        }
        offset += 2;
        if (!positive) {
            year *= -1;
        }
        if (length > offset) {
            throw new HyracksDataException("Too many chars for a date only value");
        }
        if (!GregorianCalendarSystem.getInstance().validate(year, month, day, 0, 0, 0, 0)) {
            throw new HyracksDataException(dateErrorMessage);
        }
        return GregorianCalendarSystem.getInstance().getChronon(year, month, day, 0, 0, 0, 0, 0);
    }

    public static int parseDatePartInDays(String dateString, int start, int length) throws HyracksDataException {
        long chronon = ADateParserFactory.parseDatePart(dateString, start, length);
        return ADateParserFactory.convertParsedMillisecondsToDays(chronon);
    }

    public static int parseDatePartInDays(char[] dateString, int start, int length) throws HyracksDataException {
        long chronon = ADateParserFactory.parseDatePart(dateString, start, length);
        return ADateParserFactory.convertParsedMillisecondsToDays(chronon);
    }

    public static int convertParsedMillisecondsToDays(long chronon) throws HyracksDataException {
        if (chronon >= 0L) {
            return (int)(chronon / 86400000L);
        }
        if (chronon % 86400000L != 0L) {
            return (int)(chronon / 86400000L - 1L);
        }
        return (int)(chronon / 86400000L);
    }
}

