/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt16TypeConvertComputer
implements ITypeConvertComputer {
    private static final DoubleToInt16TypeConvertComputer INSTANCE_STRICT = new DoubleToInt16TypeConvertComputer(true);
    private static final DoubleToInt16TypeConvertComputer INSTANCE_LAX = new DoubleToInt16TypeConvertComputer(false);
    private final boolean strict;

    private DoubleToInt16TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static DoubleToInt16TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        short targetValue = this.convert(sourceValue);
        out.writeByte(ATypeTag.SMALLINT.serialize());
        out.writeShort(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        double sourceValue = ATypeHierarchy.applyMathFunctionToDoubleValue(sourceObject, mathFunction);
        short targetValue = this.convert(sourceValue);
        return new AInt16(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short convert(double sourceValue) throws HyracksDataException {
        if (Double.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryCheckException(sourceValue);
        }
        if (sourceValue > 32767.0) {
            if (!this.strict) return Short.MAX_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
            return (short)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -32768.0)) return (short)Math.floor(sourceValue);
            if (!this.strict) return Short.MIN_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (short)Math.floor(sourceValue);
    }

    private void raiseBoundaryCheckException(double sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_OUT_OF_BOUND, new Serializable[]{Double.valueOf(sourceValue), ATypeTag.SMALLINT, Short.valueOf((short)Short.MAX_VALUE), Short.valueOf((short)Short.MIN_VALUE)});
    }
}

