/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.ClientCommand;

public abstract class RemoteCommand
extends ClientCommand {
    public static final int MAX_CONNECTION_TIMEOUT_SECS = 60;
    protected final String hostPort;

    public RemoteCommand(Args args) {
        super(args);
        this.hostPort = args.getClusterAddress() + ":" + args.getClusterPort();
    }

    protected int tryConnect(String path, Method method) throws MalformedURLException {
        try {
            HttpURLConnection conn = this.openConnection(path, method);
            return conn.getResponseCode();
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected int tryGet(String path) throws MalformedURLException {
        return this.tryConnect(path, Method.GET);
    }

    protected int tryPost(String path) throws MalformedURLException {
        return this.tryConnect(path, Method.POST);
    }

    protected InputStream openAsStream(String path, Method method) throws IOException {
        return this.openConnection(path, method).getInputStream();
    }

    protected HttpURLConnection openConnection(String path, Method method) throws IOException {
        URL url = new URL("http://" + this.hostPort + "/" + path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        int timeoutMillis = (int)TimeUnit.SECONDS.toMillis(Math.max(60, this.args.getTimeoutSecs()));
        conn.setConnectTimeout(timeoutMillis);
        conn.setReadTimeout(timeoutMillis);
        conn.setRequestMethod(method.name());
        conn.setRequestProperty("Connection", "close");
        return conn;
    }

    protected static enum Method {
        GET,
        POST;

    }
}

