/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;

public class SingleFrameBufferManager
implements ISimpleFrameBufferManager {
    boolean isAcquired = false;
    ByteBuffer buffer = null;

    @Override
    public ByteBuffer acquireFrame(int frameSize) throws HyracksDataException {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(frameSize);
        }
        if (this.isAcquired) {
            return null;
        }
        if (this.buffer.capacity() >= frameSize) {
            this.isAcquired = true;
            this.buffer.clear();
            Arrays.fill(this.buffer.array(), (byte)0);
            return this.buffer;
        }
        throw new HyracksDataException("Frame size changed");
    }

    @Override
    public void releaseFrame(ByteBuffer frame) {
        this.buffer.clear();
        this.isAcquired = false;
    }
}

