/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.LeftOuterTypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.OpRefTypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.exceptions.ErrorCode;

public class LeftOuterJoinOperator
extends AbstractBinaryJoinOperator {
    private IAlgebricksConstantValue missingValue;

    public LeftOuterJoinOperator(Mutable<ILogicalExpression> condition, IAlgebricksConstantValue missingValue) {
        super(AbstractBinaryJoinOperator.JoinKind.LEFT_OUTER, condition);
        this.setMissingValue(missingValue);
    }

    public LeftOuterJoinOperator(Mutable<ILogicalExpression> condition, Mutable<ILogicalOperator> input1, Mutable<ILogicalOperator> input2, IAlgebricksConstantValue missingValue) {
        super(AbstractBinaryJoinOperator.JoinKind.LEFT_OUTER, condition, input1, input2);
        this.setMissingValue(missingValue);
    }

    public IAlgebricksConstantValue getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(IAlgebricksConstantValue value) {
        this.missingValue = LeftOuterJoinOperator.validateMissingValue(value);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.LEFTOUTERJOIN;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitLeftOuterJoinOperator(this, arg);
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        TypePropagationPolicy typePropagationPolicy;
        int n = this.inputs.size();
        ITypeEnvPointer[] envPointers = new ITypeEnvPointer[n];
        for (int i = 0; i < n; ++i) {
            envPointers[i] = new OpRefTypeEnvPointer((Mutable<ILogicalOperator>)((Mutable)this.inputs.get(i)), ctx);
        }
        if (this.missingValue.isMissing()) {
            typePropagationPolicy = LeftOuterTypePropagationPolicy.MISSABLE;
        } else if (this.missingValue.isNull()) {
            typePropagationPolicy = LeftOuterTypePropagationPolicy.NULLABLE;
        } else {
            throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, new Serializable[]{String.valueOf(this.missingValue)});
        }
        PropagatingTypeEnvironment env = new PropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMissableTypeComputer(), ctx.getMetadataProvider(), typePropagationPolicy, envPointers);
        ArrayList<LogicalVariable> liveVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)((Mutable)this.inputs.get(1)).getValue(), liveVars);
        if (this.missingValue.isMissing()) {
            env.getCorrelatedMissableVariableLists().add(liveVars);
        } else if (this.missingValue.isNull()) {
            env.getCorrelatedNullableVariableLists().add(liveVars);
        } else {
            throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, new Serializable[]{String.valueOf(this.missingValue)});
        }
        return env;
    }

    private static IAlgebricksConstantValue validateMissingValue(IAlgebricksConstantValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.isMissing()) {
            return ConstantExpression.MISSING.getValue();
        }
        if (value.isNull()) {
            return ConstantExpression.NULL.getValue();
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }
}

