/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.application;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServerContext;
import org.apache.hyracks.api.application.IStateDumpHandler;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.resources.memory.IMemoryManager;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.common.application.ServiceContext;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.utils.HyracksThreadFactory;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.resources.memory.MemoryManager;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.hyracks.util.trace.TraceCategoryRegistry;
import org.apache.hyracks.util.trace.Tracer;

public class NCServiceContext
extends ServiceContext
implements INCServiceContext {
    private final ILifeCycleComponentManager lccm;
    private final String nodeId;
    private final IOManager ioManager;
    private final MemoryManager memoryManager;
    private IStateDumpHandler sdh;
    private final NodeControllerService ncs;
    private IChannelInterfaceFactory messagingChannelInterfaceFactory;
    private final ITracer tracer;

    public NCServiceContext(NodeControllerService ncs, ServerContext serverCtx, IOManager ioManager, String nodeId, MemoryManager memoryManager, ILifeCycleComponentManager lifeCyclecomponentManager, IApplicationConfig appConfig) {
        super((IServerContext)serverCtx, appConfig, (ThreadFactory)new HyracksThreadFactory(nodeId));
        this.lccm = lifeCyclecomponentManager;
        this.nodeId = nodeId;
        this.ioManager = ioManager;
        this.memoryManager = memoryManager;
        this.ncs = ncs;
        this.sdh = arg_0 -> ((ILifeCycleComponentManager)this.lccm).dumpState(arg_0);
        this.tracer = new Tracer(nodeId, ncs.getConfiguration().getTraceCategories(), new TraceCategoryRegistry());
        this.distributedState = new ConcurrentHashMap();
    }

    public ILifeCycleComponentManager getLifeCycleComponentManager() {
        return this.lccm;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setDistributedState(Serializable state) {
        this.distributedState = state;
    }

    public void setStateDumpHandler(IStateDumpHandler handler) {
        this.sdh = handler;
    }

    public IStateDumpHandler getStateDumpHandler() {
        return this.sdh;
    }

    public IOManager getIoManager() {
        return this.ioManager;
    }

    public IMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ITracer getTracer() {
        return this.tracer;
    }

    public IControllerService getControllerService() {
        return this.ncs;
    }

    public IChannelInterfaceFactory getMessagingChannelInterfaceFactory() {
        return this.messagingChannelInterfaceFactory;
    }

    public void setMessagingChannelInterfaceFactory(IChannelInterfaceFactory interfaceFactory) {
        this.messagingChannelInterfaceFactory = interfaceFactory;
    }

    public Object getApplicationContext() {
        return this.ncs.getApplicationContext();
    }
}

