/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntime;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SinkWriterRuntimeFactory
extends AbstractPushRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] fields;
    private final IPrinterFactory[] printerFactories;
    private final File outputFile;
    private final RecordDescriptor inputRecordDesc;
    private final IAWriterFactory writerFactory;

    public SinkWriterRuntimeFactory(int[] fields, IPrinterFactory[] printerFactories, File outputFile, IAWriterFactory writerFactory, RecordDescriptor inputRecordDesc) {
        this.fields = fields;
        this.printerFactories = printerFactories;
        this.outputFile = outputFile;
        this.writerFactory = writerFactory;
        this.inputRecordDesc = inputRecordDesc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("sink-write [");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.fields[i]);
        }
        buf.append("] outputFile");
        return buf.toString();
    }

    @Override
    public IPushRuntime[] createPushRuntime(IHyracksTaskContext ctx) throws HyracksDataException {
        try {
            PrintStream filePrintStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
            IAWriter w = this.writerFactory.createWriter(this.fields, filePrintStream, this.printerFactories, this.inputRecordDesc);
            return new IPushRuntime[]{new SinkWriterRuntime(w, filePrintStream, this.inputRecordDesc, true)};
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

