/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.internal.Utils;
import io.opencensus.implcore.metrics.Meter;
import io.opencensus.metrics.DoubleGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DoubleGaugeImpl
extends DoubleGauge
implements Meter {
    @VisibleForTesting
    static final LabelValue UNSET_VALUE = LabelValue.create(null);
    private final MetricDescriptor metricDescriptor;
    private volatile Map<List<LabelValue>, PointImpl> registeredPoints = Collections.emptyMap();
    private final int labelKeysSize;
    private final List<LabelValue> defaultLabelValues;
    private final List<LabelValue> constantLabelValues;

    DoubleGaugeImpl(String name, String description, String unit, List<LabelKey> labelKeys, Map<LabelKey, LabelValue> constantLabels) {
        ArrayList<LabelValue> constantLabelValues = new ArrayList<LabelValue>();
        ArrayList<LabelKey> allKeys = new ArrayList<LabelKey>(labelKeys);
        for (Map.Entry<LabelKey, LabelValue> label : constantLabels.entrySet()) {
            allKeys.add(label.getKey());
            constantLabelValues.add(label.getValue());
        }
        this.labelKeysSize = allKeys.size();
        this.metricDescriptor = MetricDescriptor.create((String)name, (String)description, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_DOUBLE, allKeys);
        this.constantLabelValues = Collections.unmodifiableList(constantLabelValues);
        this.defaultLabelValues = new ArrayList<LabelValue>(labelKeys.size());
        for (int i = 0; i < labelKeys.size(); ++i) {
            this.defaultLabelValues.add(UNSET_VALUE);
        }
        this.defaultLabelValues.addAll(constantLabelValues);
    }

    public DoubleGauge.DoublePoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
        PointImpl existingPoint = this.registeredPoints.get(labelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>((Collection)Preconditions.checkNotNull(labelValues, (Object)"labelValues"));
        labelValuesCopy.addAll(this.constantLabelValues);
        return this.registerTimeSeries(Collections.unmodifiableList(labelValuesCopy));
    }

    public DoubleGauge.DoublePoint getDefaultTimeSeries() {
        PointImpl existingPoint = this.registeredPoints.get(this.defaultLabelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        return this.registerTimeSeries(Collections.unmodifiableList(this.defaultLabelValues));
    }

    public synchronized void removeTimeSeries(List<LabelValue> labelValues) {
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>((Collection)Preconditions.checkNotNull(labelValues, (Object)"labelValues"));
        labelValuesCopy.addAll(this.constantLabelValues);
        LinkedHashMap<List<LabelValue>, PointImpl> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointImpl>(this.registeredPoints);
        if (registeredPointsCopy.remove(labelValuesCopy) == null) {
            return;
        }
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void clear() {
        this.registeredPoints = Collections.emptyMap();
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    private synchronized DoubleGauge.DoublePoint registerTimeSeries(List<LabelValue> labelValues) {
        PointImpl existingPoint = this.registeredPoints.get(labelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        Preconditions.checkArgument((this.labelKeysSize == labelValues.size() ? 1 : 0) != 0, (Object)"Label Keys and Label Values don't have same size.");
        Utils.checkListElementNotNull(labelValues, "labelValue");
        PointImpl newPoint = new PointImpl(labelValues);
        LinkedHashMap<List<LabelValue>, PointImpl> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointImpl>(this.registeredPoints);
        registeredPointsCopy.put(labelValues, newPoint);
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
        return newPoint;
    }

    @Override
    @Nullable
    public Metric getMetric(Clock clock) {
        Map<List<LabelValue>, PointImpl> currentRegisteredPoints = this.registeredPoints;
        if (currentRegisteredPoints.isEmpty()) {
            return null;
        }
        if (currentRegisteredPoints.size() == 1) {
            PointImpl point = currentRegisteredPoints.values().iterator().next();
            return Metric.createWithOneTimeSeries((MetricDescriptor)this.metricDescriptor, (TimeSeries)point.getTimeSeries(clock));
        }
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(currentRegisteredPoints.size());
        for (Map.Entry<List<LabelValue>, PointImpl> entry : currentRegisteredPoints.entrySet()) {
            timeSeriesList.add(entry.getValue().getTimeSeries(clock));
        }
        return Metric.create((MetricDescriptor)this.metricDescriptor, timeSeriesList);
    }

    public static final class PointImpl
    extends DoubleGauge.DoublePoint {
        private final AtomicDouble value = new AtomicDouble(0.0);
        private final TimeSeries defaultTimeSeries;

        PointImpl(List<LabelValue> labelValues) {
            this.defaultTimeSeries = TimeSeries.create(labelValues);
        }

        public void add(double amt) {
            this.value.addAndGet(amt);
        }

        public void set(double val) {
            this.value.set(val);
        }

        private TimeSeries getTimeSeries(Clock clock) {
            return this.defaultTimeSeries.setPoint(Point.create((Value)Value.doubleValue((double)this.value.get()), (Timestamp)clock.now()));
        }
    }
}

