/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import java.nio.ByteBuffer;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;

public class RTreeSplitKey
implements ISplitKey {
    public byte[] leftPageData = null;
    public ByteBuffer leftPageBuf = null;
    public ITreeIndexTupleReference leftTuple;
    public byte[] rightPageData = null;
    public ByteBuffer rightPageBuf = null;
    public ITreeIndexTupleReference rightTuple;
    public int keySize = 0;

    public RTreeSplitKey(ITreeIndexTupleReference leftTuple, ITreeIndexTupleReference rightTuple) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
    }

    public void initData(int keySize) {
        this.keySize = keySize;
        if (this.leftPageData != null) {
            if (this.leftPageData.length < keySize + 4) {
                this.leftPageData = new byte[keySize + 4];
                this.leftPageBuf = ByteBuffer.wrap(this.leftPageData);
            }
        } else {
            this.leftPageData = new byte[keySize + 4];
            this.leftPageBuf = ByteBuffer.wrap(this.leftPageData);
        }
        if (this.rightPageData != null) {
            if (this.rightPageData.length < keySize + 4) {
                this.rightPageData = new byte[keySize + 4];
                this.rightPageBuf = ByteBuffer.wrap(this.rightPageData);
            }
        } else {
            this.rightPageData = new byte[keySize + 4];
            this.rightPageBuf = ByteBuffer.wrap(this.rightPageData);
        }
        this.leftTuple.resetByTupleOffset(this.leftPageBuf.array(), 0);
        this.rightTuple.resetByTupleOffset(this.rightPageBuf.array(), 0);
    }

    public void resetLeftPage() {
        this.leftPageData = null;
        this.leftPageBuf = null;
    }

    public void resetRightPage() {
        this.rightPageData = null;
        this.rightPageBuf = null;
    }

    public ByteBuffer getLeftPageBuffer() {
        return this.leftPageBuf;
    }

    public ByteBuffer getRightPageBuffer() {
        return this.rightPageBuf;
    }

    public ITreeIndexTupleReference getLeftTuple() {
        return this.leftTuple;
    }

    public ITreeIndexTupleReference getRightTuple() {
        return this.rightTuple;
    }

    public int getLeftPage() {
        return this.leftPageBuf.getInt(this.keySize);
    }

    public int getRightPage() {
        return this.rightPageBuf.getInt(this.keySize);
    }

    public void setLeftPage(int page) {
        this.leftPageBuf.putInt(this.keySize, page);
    }

    public void setRightPage(int page) {
        this.rightPageBuf.putInt(this.keySize, page);
    }

    public ISplitKey duplicate(ITreeIndexTupleReference copyLeftTuple, ITreeIndexTupleReference copyRightTuple) {
        RTreeSplitKey copy = new RTreeSplitKey(copyLeftTuple, copyRightTuple);
        copy.leftPageData = (byte[])this.leftPageData.clone();
        copy.leftPageBuf = ByteBuffer.wrap(copy.leftPageData);
        copy.leftTuple.setFieldCount(this.leftTuple.getFieldCount());
        copy.leftTuple.resetByTupleOffset(copy.leftPageBuf.array(), 0);
        copy.rightPageData = (byte[])this.rightPageData.clone();
        copy.rightPageBuf = ByteBuffer.wrap(copy.rightPageData);
        copy.rightTuple.setFieldCount(this.rightTuple.getFieldCount());
        copy.rightTuple.resetByTupleOffset(copy.rightPageBuf.array(), 0);
        return copy;
    }

    public void reset() {
        this.leftPageData = null;
        this.leftPageBuf = null;
        this.rightPageData = null;
        this.rightPageBuf = null;
    }

    public ByteBuffer getBuffer() {
        return null;
    }

    public ITreeIndexTupleReference getTuple() {
        return null;
    }

    public void setPages(int leftPage, int rightPage) {
        this.leftPageBuf.putInt(this.keySize, leftPage);
        this.rightPageBuf.putInt(this.keySize, rightPage);
    }

    public ISplitKey duplicate(ITreeIndexTupleReference copyTuple) {
        return null;
    }
}

