/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.scheduler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.hdfs.api.INcCollection;
import org.apache.hyracks.hdfs.api.INcCollectionBuilder;
import org.apache.hyracks.hdfs.scheduler.IPProximityNcCollectionBuilder;
import org.apache.hyracks.hdfs.scheduler.RackAwareNcCollectionBuilder;
import org.apache.hyracks.ipc.impl.HyracksConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Scheduler {
    public static final InputSplit[] EMPTY_INPUT_SPLITS = new InputSplit[0];
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] NCs;
    private Map<String, List<String>> ipToNcMapping = new HashMap<String, List<String>>();
    private Map<String, Integer> ncNameToIndex = new HashMap<String, Integer>();
    private Map<String, NodeControllerInfo> ncNameToNcInfos;
    private INcCollectionBuilder ncCollectionBuilder;

    public Scheduler(String ipAddress, int port, ISocketChannelFactory channelFactory) throws HyracksException {
        try {
            HyracksConnection hcc = new HyracksConnection(ipAddress, port, channelFactory);
            this.ncNameToNcInfos = hcc.getNodeControllerInfos();
            ClusterTopology topology = hcc.getClusterTopology();
            this.ncCollectionBuilder = topology == null ? new IPProximityNcCollectionBuilder() : new RackAwareNcCollectionBuilder(topology);
            this.loadIPAddressToNCMap(this.ncNameToNcInfos);
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    public Scheduler(Map<String, NodeControllerInfo> ncNameToNcInfos) throws HyracksException {
        this.ncNameToNcInfos = ncNameToNcInfos;
        this.ncCollectionBuilder = new IPProximityNcCollectionBuilder();
        this.loadIPAddressToNCMap(ncNameToNcInfos);
    }

    public Scheduler(Map<String, NodeControllerInfo> ncNameToNcInfos, ClusterTopology topology) throws HyracksException {
        this(ncNameToNcInfos);
        this.ncCollectionBuilder = topology == null ? new IPProximityNcCollectionBuilder() : new RackAwareNcCollectionBuilder(topology);
    }

    public Scheduler(Map<String, NodeControllerInfo> ncNameToNcInfos, INcCollectionBuilder ncCollectionBuilder) throws HyracksException {
        this.ncNameToNcInfos = ncNameToNcInfos;
        this.ncCollectionBuilder = ncCollectionBuilder;
        this.loadIPAddressToNCMap(ncNameToNcInfos);
    }

    public String[] getLocationConstraints(InputSplit[] splits) throws HyracksException {
        if (splits == null || splits == EMPTY_INPUT_SPLITS) {
            return new String[0];
        }
        int[] workloads = new int[this.NCs.length];
        Arrays.fill(workloads, 0);
        String[] locations = new String[splits.length];
        HashMap<String, IntWritable> locationToNumOfSplits = new HashMap<String, IntWritable>();
        int upperBoundSlots = splits.length % workloads.length == 0 ? splits.length / workloads.length : splits.length / workloads.length + 1;
        int lowerBoundSlots = splits.length % workloads.length == 0 ? upperBoundSlots : upperBoundSlots - 1;
        try {
            Random random = new Random(System.currentTimeMillis());
            boolean[] scheduled = new boolean[splits.length];
            Arrays.fill(scheduled, false);
            this.buildPopularityMap(splits, locationToNumOfSplits);
            this.scheduleLocalSlots(splits, workloads, locations, lowerBoundSlots, random, scheduled, locationToNumOfSplits);
            this.scheduleLocalSlots(splits, workloads, locations, upperBoundSlots, random, scheduled, locationToNumOfSplits);
            int dataLocalCount = 0;
            for (int i = 0; i < scheduled.length; ++i) {
                if (!scheduled[i]) continue;
                ++dataLocalCount;
            }
            LOGGER.info("Data local rate: " + (scheduled.length == 0 ? 0.0 : (double)((float)dataLocalCount / (float)scheduled.length)));
            this.scheduleNonLocalSlots(splits, workloads, locations, lowerBoundSlots, scheduled);
            this.scheduleNonLocalSlots(splits, workloads, locations, upperBoundSlots, scheduled);
            return locations;
        }
        catch (IOException e) {
            throw HyracksException.create((Throwable)e);
        }
    }

    private void scheduleNonLocalSlots(InputSplit[] splits, int[] workloads, String[] locations, int slotLimit, boolean[] scheduled) throws IOException, UnknownHostException {
        INcCollection ncCollection = this.ncCollectionBuilder.build(this.ncNameToNcInfos, this.ipToNcMapping, this.ncNameToIndex, this.NCs, workloads, slotLimit);
        if (ncCollection.numAvailableSlots() == 0) {
            return;
        }
        for (int i = 0; i < splits.length; ++i) {
            int ncIndex;
            InputSplit split;
            String selectedNcName;
            if (scheduled[i] || (selectedNcName = ncCollection.findNearestAvailableSlot(split = splits[i])) == null) continue;
            int n = ncIndex = this.ncNameToIndex.get(selectedNcName).intValue();
            workloads[n] = workloads[n] + 1;
            scheduled[i] = true;
            locations[i] = selectedNcName;
        }
    }

    private void scheduleLocalSlots(InputSplit[] splits, int[] workloads, String[] locations, int slots, Random random, boolean[] scheduled, final Map<String, IntWritable> locationToNumSplits) throws IOException, UnknownHostException {
        PriorityQueue<String> scheduleCadndiates = new PriorityQueue<String>(3, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return ((IntWritable)locationToNumSplits.get(s1)).compareTo((IntWritable)locationToNumSplits.get(s2));
            }
        });
        block0: for (int i = 0; i < splits.length; ++i) {
            String[] locs;
            if (scheduled[i] || (locs = splits[i].getLocations()).length <= 0) continue;
            scheduleCadndiates.clear();
            for (int j = 0; j < locs.length; ++j) {
                scheduleCadndiates.add(locs[j]);
            }
            for (String candidate : scheduleCadndiates) {
                InetAddress[] allIps;
                for (InetAddress ip : allIps = InetAddress.getAllByName(candidate)) {
                    int arrayPos;
                    List<String> dataLocations;
                    String nc;
                    int pos;
                    if (this.ipToNcMapping.get(ip.getHostAddress()) == null || workloads[pos = this.ncNameToIndex.get(nc = (dataLocations = this.ipToNcMapping.get(ip.getHostAddress())).get(arrayPos = random.nextInt(dataLocations.size()))).intValue()] >= slots) continue;
                    locations[i] = nc;
                    int n = pos;
                    workloads[n] = workloads[n] + 1;
                    scheduled[i] = true;
                    break;
                }
                if (!scheduled[i]) continue;
                continue block0;
            }
        }
    }

    private void buildPopularityMap(InputSplit[] splits, Map<String, IntWritable> locationToNumOfSplits) throws IOException {
        for (InputSplit split : splits) {
            String[] locations;
            for (String loc : locations = split.getLocations()) {
                IntWritable locCount = locationToNumOfSplits.get(loc);
                if (locCount == null) {
                    locCount = new IntWritable(0);
                    locationToNumOfSplits.put(loc, locCount);
                }
                locCount.set(locCount.get() + 1);
            }
        }
    }

    private void loadIPAddressToNCMap(Map<String, NodeControllerInfo> ncNameToNcInfos) throws HyracksException {
        try {
            this.NCs = new String[ncNameToNcInfos.size()];
            this.ipToNcMapping.clear();
            this.ncNameToIndex.clear();
            int i = 0;
            for (Map.Entry<String, NodeControllerInfo> entry : ncNameToNcInfos.entrySet()) {
                String ipAddr = InetAddress.getByAddress(entry.getValue().getNetworkAddress().lookupIpAddress()).getHostAddress();
                List matchedNCs = this.ipToNcMapping.computeIfAbsent(ipAddr, k -> new ArrayList());
                matchedNCs.add(entry.getKey());
                this.NCs[i] = entry.getKey();
                ++i;
            }
            for (i = 0; i < this.NCs.length; ++i) {
                this.ncNameToIndex.put(this.NCs[i], i);
            }
        }
        catch (Exception e) {
            throw HyracksException.create((Throwable)e);
        }
    }
}

