/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs2.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.InputSplit;

public class WrappedFileSplit
implements InputSplit {
    private String[] locations;
    private long length;

    public WrappedFileSplit(String[] locations, long length) {
        this.locations = locations;
        this.length = length;
    }

    public void readFields(DataInput input) throws IOException {
        int len = input.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = input.readUTF();
        }
        this.length = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        output.write(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            output.writeUTF(this.locations[i]);
        }
        output.writeLong(this.length);
    }

    public long getLength() throws IOException {
        return this.length;
    }

    public String[] getLocations() throws IOException {
        return this.locations;
    }
}

