/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.api.RequestReference;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.om.base.ADateTime;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.JSONUtil;

public abstract class BaseClientRequest
implements IClientRequest {
    private boolean complete;
    private final IRequestReference requestReference;
    private boolean cancellable = false;
    private volatile long completionTime = -1L;
    protected volatile IClientRequest.State state = IClientRequest.State.RECEIVED;

    public BaseClientRequest(IRequestReference requestReference) {
        this.requestReference = requestReference;
    }

    public synchronized void complete() {
        if (this.complete) {
            return;
        }
        this.complete = true;
        this.state = IClientRequest.State.COMPLETED;
        this.completionTime = System.currentTimeMillis();
    }

    public synchronized void cancel(ICcApplicationContext appCtx) throws HyracksDataException {
        if (this.complete) {
            return;
        }
        this.complete();
        this.state = IClientRequest.State.CANCELLED;
        if (this.cancellable) {
            this.doCancel(appCtx);
        }
    }

    public synchronized void markCancellable() {
        this.cancellable = true;
    }

    public synchronized boolean isCancelled() {
        return this.state == IClientRequest.State.CANCELLED;
    }

    public String getId() {
        return this.requestReference.getUuid();
    }

    public synchronized boolean isCancellable() {
        return this.cancellable;
    }

    public void setRunning() {
        this.state = IClientRequest.State.RUNNING;
    }

    public String toJson() {
        return JSONUtil.convertNodeUnchecked((JsonNode)this.asJson());
    }

    protected ObjectNode asJson() {
        ObjectNode json = JSONUtil.createObject();
        json.put("uuid", this.requestReference.getUuid());
        json.put("requestTime", new ADateTime(this.requestReference.getTime()).toSimpleString());
        json.put("elapsedTime", this.getElapsedTimeInSecs());
        json.put("node", this.requestReference.getNode());
        json.put("state", this.state.getLabel());
        json.put("userAgent", ((RequestReference)this.requestReference).getUserAgent());
        json.put("remoteAddr", ((RequestReference)this.requestReference).getRemoteAddr());
        json.put("cancellable", this.cancellable);
        return json;
    }

    private double getElapsedTimeInSecs() {
        long runningTime = this.completionTime > 0L ? this.completionTime : System.currentTimeMillis();
        return (double)(runningTime - this.requestReference.getTime()) / 1000.0;
    }

    protected abstract void doCancel(ICcApplicationContext var1) throws HyracksDataException;
}

