/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.ApplicationMessageWork;
import org.apache.hyracks.control.cc.work.DeployedJobFailureWork;
import org.apache.hyracks.control.cc.work.GetNodeControllersInfoWork;
import org.apache.hyracks.control.cc.work.JobletCleanupNotificationWork;
import org.apache.hyracks.control.cc.work.NodeHeartbeatWork;
import org.apache.hyracks.control.cc.work.NotifyDeployBinaryWork;
import org.apache.hyracks.control.cc.work.NotifyShutdownWork;
import org.apache.hyracks.control.cc.work.NotifyStateDumpResponse;
import org.apache.hyracks.control.cc.work.NotifyThreadDumpResponse;
import org.apache.hyracks.control.cc.work.RegisterNodeWork;
import org.apache.hyracks.control.cc.work.RegisterPartitionAvailibilityWork;
import org.apache.hyracks.control.cc.work.RegisterPartitionRequestWork;
import org.apache.hyracks.control.cc.work.RegisterResultPartitionLocationWork;
import org.apache.hyracks.control.cc.work.ReportProfilesWork;
import org.apache.hyracks.control.cc.work.ReportResultPartitionWriteCompletionWork;
import org.apache.hyracks.control.cc.work.TaskCompleteWork;
import org.apache.hyracks.control.cc.work.TaskFailureWork;
import org.apache.hyracks.control.cc.work.UnregisterNodeWork;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ClusterControllerIPCI
implements IIPCI {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;

    ClusterControllerIPCI(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    public void deliverIncomingMessage(final IIPCHandle handle, long mid, long rmid, Object payload) {
        CCNCFunctions.Function fn = (CCNCFunctions.Function)payload;
        switch (fn.getFunctionId()) {
            case REGISTER_NODE: {
                CCNCFunctions.RegisterNodeFunction rnf = (CCNCFunctions.RegisterNodeFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new RegisterNodeWork(this.ccs, rnf.getNodeRegistration(), rnf.getRegistrationId()));
                break;
            }
            case UNREGISTER_NODE: {
                CCNCFunctions.UnregisterNodeFunction unf = (CCNCFunctions.UnregisterNodeFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new UnregisterNodeWork(this.ccs.getNodeManager(), unf.getNodeId()));
                break;
            }
            case NODE_HEARTBEAT: {
                ClusterControllerIPCI.processNodeHeartbeat(this.ccs, fn);
                break;
            }
            case NOTIFY_JOBLET_CLEANUP: {
                CCNCFunctions.NotifyJobletCleanupFunction njcf = (CCNCFunctions.NotifyJobletCleanupFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new JobletCleanupNotificationWork(this.ccs, njcf.getJobId(), njcf.getNodeId()));
                break;
            }
            case NOTIFY_DEPLOY_BINARY: {
                CCNCFunctions.NotifyDeployBinaryFunction ndbf = (CCNCFunctions.NotifyDeployBinaryFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new NotifyDeployBinaryWork(this.ccs, ndbf.getDeploymentId(), ndbf.getNodeId(), ndbf.getDeploymentStatus()));
                break;
            }
            case REPORT_PROFILE: {
                CCNCFunctions.ReportProfileFunction rpf = (CCNCFunctions.ReportProfileFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new ReportProfilesWork(this.ccs.getJobManager(), rpf.getProfiles()));
                break;
            }
            case NOTIFY_TASK_COMPLETE: {
                CCNCFunctions.NotifyTaskCompleteFunction ntcf = (CCNCFunctions.NotifyTaskCompleteFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new TaskCompleteWork(this.ccs, ntcf.getJobId(), ntcf.getTaskId(), ntcf.getNodeId(), ntcf.getStatistics()));
                break;
            }
            case NOTIFY_TASK_FAILURE: {
                CCNCFunctions.NotifyTaskFailureFunction ntff = (CCNCFunctions.NotifyTaskFailureFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new TaskFailureWork(this.ccs, ntff.getJobId(), ntff.getTaskId(), ntff.getNodeId(), ntff.getExceptions()));
                break;
            }
            case DEPLOYED_JOB_FAILURE: {
                CCNCFunctions.ReportDeployedJobSpecFailureFunction rdjf = (CCNCFunctions.ReportDeployedJobSpecFailureFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new DeployedJobFailureWork(rdjf.getDeployedJobSpecId(), rdjf.getNodeId()));
                break;
            }
            case REGISTER_PARTITION_PROVIDER: {
                CCNCFunctions.RegisterPartitionProviderFunction rppf = (CCNCFunctions.RegisterPartitionProviderFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new RegisterPartitionAvailibilityWork(this.ccs, rppf.getPartitionDescriptor()));
                break;
            }
            case REGISTER_PARTITION_REQUEST: {
                CCNCFunctions.RegisterPartitionRequestFunction rprf = (CCNCFunctions.RegisterPartitionRequestFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new RegisterPartitionRequestWork(this.ccs, rprf.getPartitionRequest()));
                break;
            }
            case REGISTER_RESULT_PARTITION_LOCATION: {
                CCNCFunctions.RegisterResultPartitionLocationFunction rrplf = (CCNCFunctions.RegisterResultPartitionLocationFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new RegisterResultPartitionLocationWork(this.ccs, rrplf.getJobId(), rrplf.getResultSetId(), rrplf.getMetadata(), rrplf.getEmptyResult(), rrplf.getPartition(), rrplf.getNPartitions(), rrplf.getNetworkAddress()));
                break;
            }
            case REPORT_RESULT_PARTITION_WRITE_COMPLETION: {
                CCNCFunctions.ReportResultPartitionWriteCompletionFunction rrpwc = (CCNCFunctions.ReportResultPartitionWriteCompletionFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new ReportResultPartitionWriteCompletionWork(this.ccs, rrpwc.getJobId(), rrpwc.getResultSetId(), rrpwc.getPartition()));
                break;
            }
            case SEND_APPLICATION_MESSAGE: {
                CCNCFunctions.SendApplicationMessageFunction rsf = (CCNCFunctions.SendApplicationMessageFunction)fn;
                ApplicationMessageWork work = new ApplicationMessageWork(this.ccs, rsf.getMessage(), rsf.getDeploymentId(), rsf.getNodeId());
                if (rsf.isRealTime()) {
                    ExecutorService executor = this.ccs.getExecutor();
                    if (executor == null) break;
                    executor.execute((Runnable)((Object)work));
                    break;
                }
                this.ccs.getWorkQueue().schedule((AbstractWork)work);
                break;
            }
            case GET_NODE_CONTROLLERS_INFO: {
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetNodeControllersInfoWork(this.ccs.getNodeManager(), new IResultCallback<Map<String, NodeControllerInfo>>(){

                    public void setValue(Map<String, NodeControllerInfo> result) {
                        new IPCResponder(handle, -1L).setValue((Object)new CCNCFunctions.GetNodeControllersInfoResponseFunction(result));
                    }

                    public void setException(Exception e) {
                    }
                }));
                break;
            }
            case STATE_DUMP_RESPONSE: {
                CCNCFunctions.StateDumpResponseFunction dsrf = (CCNCFunctions.StateDumpResponseFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new NotifyStateDumpResponse(this.ccs, dsrf.getNodeId(), dsrf.getStateDumpId(), dsrf.getState()));
                break;
            }
            case SHUTDOWN_RESPONSE: {
                CCNCFunctions.ShutdownResponseFunction sdrf = (CCNCFunctions.ShutdownResponseFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new NotifyShutdownWork(this.ccs, sdrf.getNodeId()));
                break;
            }
            case THREAD_DUMP_RESPONSE: {
                CCNCFunctions.ThreadDumpResponseFunction tdrf = (CCNCFunctions.ThreadDumpResponseFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new NotifyThreadDumpResponse(this.ccs, tdrf.getRequestId(), tdrf.getThreadDumpJSON()));
                break;
            }
            case PING_RESPONSE: {
                CCNCFunctions.PingResponseFunction prf = (CCNCFunctions.PingResponseFunction)fn;
                LOGGER.debug("Received ping response from node {}", (Object)prf.getNodeId());
                break;
            }
            default: {
                LOGGER.warn("Unknown function: " + fn.getFunctionId());
            }
        }
    }

    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        LOGGER.info("exception in/or processing message", (Throwable)exception);
    }

    private static void processNodeHeartbeat(ClusterControllerService ccs, CCNCFunctions.Function fn) {
        ExecutorService executor = ccs.getExecutor();
        if (executor != null) {
            CCNCFunctions.NodeHeartbeatFunction nhf = (CCNCFunctions.NodeHeartbeatFunction)fn;
            executor.execute((Runnable)((Object)new NodeHeartbeatWork(ccs, nhf.getNodeId(), nhf.getHeartbeatData(), nhf.getNcAddress())));
        }
    }
}

