/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class UndeployJobSpecWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final DeployedJobSpecId deployedJobSpecId;
    private final IResultCallback<Void> callback;

    public UndeployJobSpecWork(ClusterControllerService ccs, DeployedJobSpecId deployedJobSpecId, IResultCallback<Void> callback) {
        this.deployedJobSpecId = deployedJobSpecId;
        this.ccs = ccs;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        try {
            this.ccs.getDeployedJobSpecStore().removeDeployedJobSpecDescriptor(this.deployedJobSpecId);
            INodeManager nodeManager = this.ccs.getNodeManager();
            for (NodeControllerState node : nodeManager.getAllNodeControllerStates()) {
                node.getNodeController().undeployJobSpec(this.deployedJobSpecId);
            }
            this.callback.setValue(null);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

