/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.ITokenFactory;

public class DelimitedUTF8StringBinaryTokenizerFactory
implements IBinaryTokenizerFactory {
    private static final long serialVersionUID = 1L;
    private final boolean ignoreTokenCount;
    private final boolean sourceHasTypeTag;
    private final ITokenFactory tokenFactory;

    public DelimitedUTF8StringBinaryTokenizerFactory(boolean ignoreTokenCount, boolean sourceHasTypeTag, ITokenFactory tokenFactory) {
        this.ignoreTokenCount = ignoreTokenCount;
        this.sourceHasTypeTag = sourceHasTypeTag;
        this.tokenFactory = tokenFactory;
    }

    @Override
    public IBinaryTokenizer createTokenizer() {
        return new DelimitedUTF8StringBinaryTokenizer(this.ignoreTokenCount, this.sourceHasTypeTag, this.tokenFactory);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("tokenFactory", this.tokenFactory.toJson(registry));
        json.put("ignoreTokenCount", this.ignoreTokenCount);
        json.put("sourceHasTypeTag", this.sourceHasTypeTag);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        ITokenFactory tokenFactory = (ITokenFactory)registry.deserialize(json.get("tokenFactory"));
        boolean ignoreTokenCount = json.get("ignoreTokenCount").asBoolean();
        boolean sourceHasTypeTag = json.get("sourceHasTypeTag").asBoolean();
        return new DelimitedUTF8StringBinaryTokenizerFactory(ignoreTokenCount, sourceHasTypeTag, tokenFactory);
    }
}

