/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Crc32cUtility;

abstract class Crc32cValue<Res extends Crc32cValue<Res>> {
    private Crc32cValue() {
    }

    public abstract int getValue();

    public abstract Res concat(Crc32cLengthKnown var1);

    public abstract String debugString();

    public boolean eqValue(Crc32cValue<?> other) {
        return this.getValue() == other.getValue();
    }

    static Crc32cLengthUnknown of(int value) {
        return new Crc32cLengthUnknown(value);
    }

    static Crc32cLengthKnown of(int value, long length) {
        return new Crc32cLengthKnown(value, length);
    }

    static String fmtCrc32cValue(int value1) {
        return String.format("crc32c{0x%08x}", value1);
    }

    static final class Crc32cLengthUnknown
    extends Crc32cValue<Crc32cLengthUnknown> {
        private final int value;

        public Crc32cLengthUnknown(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public Crc32cLengthUnknown concat(Crc32cLengthKnown other) {
            int combined = Crc32cUtility.crc32cCombineGoogle(this.value, other.value, other.length);
            return new Crc32cLengthUnknown(combined);
        }

        public String toString() {
            return Crc32cLengthKnown.fmtCrc32cValue(this.value);
        }

        @Override
        public String debugString() {
            return this.toString();
        }

        public Crc32cLengthKnown withLength(long length) {
            return new Crc32cLengthKnown(this.value, length);
        }
    }

    static final class Crc32cLengthKnown
    extends Crc32cValue<Crc32cLengthKnown> {
        private final int value;
        private final long length;

        private Crc32cLengthKnown(int value, long length) {
            this.value = value;
            this.length = length;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public Crc32cLengthKnown concat(Crc32cLengthKnown other) {
            int combined = Crc32cUtility.crc32cCombineGoogle(this.value, other.value, other.length);
            return new Crc32cLengthKnown(combined, this.length + other.length);
        }

        public String toString() {
            return String.format("crc32c{0x%08x (length = %d)}", this.value, this.length);
        }

        @Override
        public String debugString() {
            return Crc32cLengthKnown.fmtCrc32cValue(this.value);
        }
    }
}

