/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMsiCredential
extends ManagedIdentityServiceCredential {
    private final String msiEndpoint;
    private final String msiSecret;
    private final ClientLogger logger = new ClientLogger(AppServiceMsiCredential.class);

    AppServiceMsiCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE APP SERVICE MSI/IDENTITY ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.msiEndpoint = configuration.get("MSI_ENDPOINT");
        this.msiSecret = configuration.get("MSI_SECRET");
        if (this.msiEndpoint != null) {
            this.validateEndpointProtocol(this.msiEndpoint, "MSI", this.logger);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(null, null, this.msiEndpoint, this.msiSecret, request);
    }
}

