/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import com.google.common.collect.ImmutableList;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;

public class FullTextConfigMetadataEntityTupleTranslator
extends AbstractTupleTranslator<FullTextConfigMetadataEntity> {
    private static final int FULL_TEXT_CONFIG_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    protected final ArrayTupleReference tuple;
    protected final ISerializerDeserializer<AInt8> int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);

    protected FullTextConfigMetadataEntityTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FULL_TEXT_CONFIG_DATASET, 2);
        this.tuple = getTuple ? new ArrayTupleReference() : null;
    }

    @Override
    protected FullTextConfigMetadataEntity createMetadataEntityFromARecord(ARecord aRecord) throws HyracksDataException, AlgebricksException {
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)((AString)aRecord.getValueByPos(0)).getStringValue());
        String name = ((AString)aRecord.getValueByPos(1)).getStringValue();
        TokenizerCategory tokenizerCategory = (TokenizerCategory)EnumUtils.getEnumIgnoreCase(TokenizerCategory.class, (String)((AString)aRecord.getValueByPos(2)).getStringValue());
        ImmutableList.Builder filterNamesBuilder = ImmutableList.builder();
        IACursor filterNamesCursor = ((AOrderedList)aRecord.getValueByPos(3)).getCursor();
        while (filterNamesCursor.next()) {
            filterNamesBuilder.add((Object)((AString)filterNamesCursor.get()).getStringValue());
        }
        FullTextConfigDescriptor configDescriptor = new FullTextConfigDescriptor(dataverseName, name, tokenizerCategory, filterNamesBuilder.build());
        FullTextConfigMetadataEntity configMetadataEntity = new FullTextConfigMetadataEntity(configDescriptor);
        return configMetadataEntity;
    }

    private void writeIndex(String dataverseName, String configName, ArrayTupleBuilder tupleBuilder) throws HyracksDataException {
        this.aString.setValue(dataverseName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        this.aString.setValue(configName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FullTextConfigMetadataEntity configMetadataEntity) throws HyracksDataException {
        this.tupleBuilder.reset();
        FullTextConfigDescriptor configDescriptor = configMetadataEntity.getFullTextConfig();
        this.writeIndex(configDescriptor.getDataverseName().getCanonicalForm(), configDescriptor.getName(), this.tupleBuilder);
        this.recordBuilder.reset(MetadataRecordTypes.FULL_TEXT_CONFIG_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getTokenizerCategory().name());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        ImmutableList filterNames = configDescriptor.getFilterNames();
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (String s : filterNames) {
            itemValue.reset();
            this.aString.setValue(s);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

