/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.utils;

import java.util.List;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrameFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMLeafFrameFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.DiskBTree;
import org.apache.hyracks.storage.am.btree.tuples.BTreeTypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeWithBuddy;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeFileManager;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBloomFilterDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyFileManager;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeCopyTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.frames.LSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.ComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskBTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public class LSMBTreeUtil {
    private LSMBTreeUtil() {
    }

    public static LSMBTree createLSMTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, boolean needKeyDupCheck, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] btreeFields, int[] filterFields, boolean durable, IMetadataPageManagerFactory freePageManagerFactory, boolean updateAware, ITracer tracer, ICompressorDecompressorFactory compressorDecompressorFactory, boolean hasBloomFilter, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) throws HyracksDataException {
        Object bulkLoadComponentFactory;
        Object componentFactory;
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false, updateAware, nullTypeTraits, nullIntrospector);
        LSMBTreeTupleWriterFactory deleteTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, true, updateAware, nullTypeTraits, nullIntrospector);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length, updateAware, nullTypeTraits, nullIntrospector);
        LSMBTreeTupleWriterFactory bulkLoadTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false, updateAware, nullTypeTraits, nullIntrospector);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMLeafFrameFactory deleteLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)deleteTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory bulkLoadLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)bulkLoadTupleWriterFactory);
        DiskBTreeFactory diskBTreeFactory = new DiskBTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        DiskBTreeFactory bulkLoadBTreeFactory = new DiskBTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)bulkLoadLeafFrameFactory, cmpFactories, typeTraits.length);
        ComponentFilterHelper filterHelper = null;
        LSMComponentFilterFrameFactory filterFrameFactory = null;
        LSMComponentFilterManager filterManager = null;
        if (filterCmpFactories != null) {
            TypeAwareTupleWriterFactory filterTupleWriterFactory = new TypeAwareTupleWriterFactory(filterTypeTraits, nullTypeTraits, nullIntrospector);
            filterHelper = new ComponentFilterHelper((ITreeIndexTupleWriterFactory)filterTupleWriterFactory, filterCmpFactories);
            filterFrameFactory = new LSMComponentFilterFrameFactory((ITreeIndexTupleWriterFactory)filterTupleWriterFactory);
            filterManager = new LSMComponentFilterManager((ILSMComponentFilterFrameFactory)filterFrameFactory);
        }
        LSMBTreeFileManager fileNameManager = new LSMBTreeFileManager(ioManager, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, hasBloomFilter, compressorDecompressorFactory);
        if (hasBloomFilter) {
            BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, bloomFilterKeyFields);
            componentFactory = new LSMBTreeWithBloomFilterDiskComponentFactory((TreeIndexFactory<DiskBTree>)diskBTreeFactory, bloomFilterFactory, (IComponentFilterHelper)filterHelper);
            bulkLoadComponentFactory = new LSMBTreeWithBloomFilterDiskComponentFactory((TreeIndexFactory<DiskBTree>)bulkLoadBTreeFactory, bloomFilterFactory, (IComponentFilterHelper)filterHelper);
        } else {
            componentFactory = new LSMBTreeDiskComponentFactory((TreeIndexFactory<DiskBTree>)diskBTreeFactory, (IComponentFilterHelper)filterHelper);
            bulkLoadComponentFactory = new LSMBTreeDiskComponentFactory((TreeIndexFactory<DiskBTree>)bulkLoadBTreeFactory, (IComponentFilterHelper)filterHelper);
        }
        return new LSMBTree(ioManager, virtualBufferCaches, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)deleteLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, (ILSMDiskComponentFactory)componentFactory, (ILSMDiskComponentFactory)bulkLoadComponentFactory, (IComponentFilterHelper)filterHelper, (ILSMComponentFilterFrameFactory)filterFrameFactory, filterManager, bloomFilterFalsePositiveRate, typeTraits.length, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, needKeyDupCheck, hasBloomFilter, btreeFields, filterFields, durable, updateAware, tracer);
    }

    public static ExternalBTree createExternalBTree(IIOManager ioManager, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, boolean durable, IMetadataPageManagerFactory freePageManagerFactory, ITracer tracer, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) throws HyracksDataException {
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false, false, nullTypeTraits, nullIntrospector);
        LSMBTreeTupleWriterFactory deleteTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, true, false, nullTypeTraits, nullIntrospector);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length, false, nullTypeTraits, nullIntrospector);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMLeafFrameFactory deleteLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)deleteTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        LSMBTreeTupleWriterFactory transactionTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false, false, nullTypeTraits, nullIntrospector);
        BTreeNSMLeafFrameFactory transactionLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)transactionTupleWriterFactory);
        DiskBTreeFactory diskBTreeFactory = new DiskBTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        DiskBTreeFactory bulkLoadBTreeFactory = new DiskBTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, cmpFactories, typeTraits.length);
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, bloomFilterKeyFields);
        DiskBTreeFactory transactionBTreeFactory = new DiskBTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)transactionLeafFrameFactory, cmpFactories, typeTraits.length);
        LSMBTreeFileManager fileNameManager = new LSMBTreeFileManager(ioManager, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, true);
        LSMBTreeWithBloomFilterDiskComponentFactory componentFactory = new LSMBTreeWithBloomFilterDiskComponentFactory((TreeIndexFactory<DiskBTree>)diskBTreeFactory, bloomFilterFactory, null);
        LSMBTreeWithBloomFilterDiskComponentFactory bulkLoadComponentFactory = new LSMBTreeWithBloomFilterDiskComponentFactory((TreeIndexFactory<DiskBTree>)bulkLoadBTreeFactory, bloomFilterFactory, null);
        LSMBTreeWithBloomFilterDiskComponentFactory transactionComponentFactory = new LSMBTreeWithBloomFilterDiskComponentFactory((TreeIndexFactory<DiskBTree>)transactionBTreeFactory, bloomFilterFactory, null);
        return new ExternalBTree(ioManager, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)deleteLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, componentFactory, bulkLoadComponentFactory, transactionComponentFactory, bloomFilterFalsePositiveRate, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, durable, tracer);
    }

    public static ExternalBTreeWithBuddy createExternalBTreeWithBuddy(IIOManager ioManager, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, int[] buddyBTreeFields, boolean durable, IMetadataPageManagerFactory freePageManagerFactory, ITracer tracer, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) throws HyracksDataException {
        ITypeTraits[] buddyBtreeTypeTraits = new ITypeTraits[buddyBTreeFields.length];
        IBinaryComparatorFactory[] buddyBtreeCmpFactories = new IBinaryComparatorFactory[buddyBTreeFields.length];
        for (int i = 0; i < buddyBtreeTypeTraits.length; ++i) {
            buddyBtreeTypeTraits[i] = typeTraits[buddyBTreeFields[i]];
            buddyBtreeCmpFactories[i] = cmpFactories[buddyBTreeFields[i]];
        }
        BTreeTypeAwareTupleWriterFactory buddyBtreeTupleWriterFactory = new BTreeTypeAwareTupleWriterFactory(buddyBtreeTypeTraits, false, nullTypeTraits, nullIntrospector);
        BTreeNSMInteriorFrameFactory buddyBtreeInteriorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)buddyBtreeTupleWriterFactory);
        BTreeNSMLeafFrameFactory buddyBtreeLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)buddyBtreeTupleWriterFactory);
        LSMBTreeTupleWriterFactory insertTupleWriterFactory = new LSMBTreeTupleWriterFactory(typeTraits, cmpFactories.length, false, false, nullTypeTraits, nullIntrospector);
        LSMBTreeCopyTupleWriterFactory copyTupleWriterFactory = new LSMBTreeCopyTupleWriterFactory(typeTraits, cmpFactories.length, false, nullTypeTraits, nullIntrospector);
        BTreeNSMLeafFrameFactory insertLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        BTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)copyTupleWriterFactory);
        BTreeNSMInteriorFrameFactory interiorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)insertTupleWriterFactory);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, cmpFactories, typeTraits.length);
        BTreeFactory bulkLoadBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, cmpFactories, typeTraits.length);
        int[] bloomFilterKeyFields = new int[buddyBtreeCmpFactories.length];
        for (int i = 0; i < buddyBtreeCmpFactories.length; ++i) {
            bloomFilterKeyFields[i] = i;
        }
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, bloomFilterKeyFields);
        BTreeFactory diskBuddyBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)buddyBtreeInteriorFrameFactory, (ITreeIndexFrameFactory)buddyBtreeLeafFrameFactory, buddyBtreeCmpFactories, buddyBtreeTypeTraits.length);
        LSMBTreeWithBuddyFileManager fileNameManager = new LSMBTreeWithBuddyFileManager(ioManager, file, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory, (TreeIndexFactory<? extends ITreeIndex>)diskBuddyBTreeFactory);
        LSMBTreeWithBuddyDiskComponentFactory componentFactory = new LSMBTreeWithBuddyDiskComponentFactory((TreeIndexFactory<BTree>)diskBTreeFactory, (TreeIndexFactory<BTree>)diskBuddyBTreeFactory, bloomFilterFactory, null);
        LSMBTreeWithBuddyDiskComponentFactory bulkLoadComponentFactory = new LSMBTreeWithBuddyDiskComponentFactory((TreeIndexFactory<BTree>)bulkLoadBTreeFactory, (TreeIndexFactory<BTree>)diskBuddyBTreeFactory, bloomFilterFactory, null);
        return new ExternalBTreeWithBuddy(ioManager, (ITreeIndexFrameFactory)interiorFrameFactory, (ITreeIndexFrameFactory)insertLeafFrameFactory, (ITreeIndexFrameFactory)buddyBtreeLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, componentFactory, bulkLoadComponentFactory, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, cmpFactories, buddyBtreeCmpFactories, buddyBTreeFields, durable, tracer);
    }
}

