/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuationState;
import com.azure.core.util.paging.PageRetriever;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ContinuablePagedByIteratorBase<C, T, P extends ContinuablePage<C, T>, E>
implements Iterator<E> {
    private final PageRetriever<C, P> pageRetriever;
    private final ContinuationState<C> continuationState;
    private final Integer defaultPageSize;
    private final ClientLogger logger;
    private volatile boolean done;

    ContinuablePagedByIteratorBase(PageRetriever<C, P> pageRetriever, ContinuationState<C> continuationState, Integer defaultPageSize, ClientLogger logger) {
        this.continuationState = continuationState;
        this.pageRetriever = pageRetriever;
        this.defaultPageSize = defaultPageSize;
        this.logger = logger;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw this.logger.logExceptionAsError(new NoSuchElementException("Iterator contains no more elements."));
        }
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        while (!this.done && this.needToRequestPage()) {
            this.requestPage();
        }
        return this.isNextAvailable();
    }

    abstract boolean needToRequestPage();

    abstract boolean isNextAvailable();

    abstract E getNext();

    synchronized void requestPage() {
        if (this.isNextAvailable() || this.done) {
            return;
        }
        AtomicBoolean receivedPages = new AtomicBoolean(false);
        this.pageRetriever.get(this.continuationState.getLastContinuationToken(), this.defaultPageSize).map(page -> {
            receivedPages.set(true);
            this.addPage(page);
            this.continuationState.setLastContinuationToken(page.getContinuationToken());
            this.done = this.continuationState.isDone();
            return page;
        }).blockLast();
        this.done = this.done || !receivedPages.get() && !this.isNextAvailable();
    }

    abstract void addPage(P var1);
}

