/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.result.IResultMetadata;

public class DistributeResultOperator
extends AbstractLogicalOperator {
    private List<Mutable<ILogicalExpression>> expressions;
    private IDataSink dataSink;
    private IResultMetadata resultMetadata;

    public DistributeResultOperator(List<Mutable<ILogicalExpression>> expressions, IDataSink dataSink, IResultMetadata resultMetadata) {
        this.expressions = expressions;
        this.dataSink = dataSink;
        this.resultMetadata = resultMetadata;
    }

    public List<Mutable<ILogicalExpression>> getExpressions() {
        return this.expressions;
    }

    public IDataSink getDataSink() {
        return this.dataSink;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.DISTRIBUTE_RESULT;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitDistributeResultOperator(this, arg);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean modif = false;
        for (int i = 0; i < this.expressions.size(); ++i) {
            boolean b = visitor.transform(this.expressions.get(i));
            if (!b) continue;
            modif = true;
        }
        return modif;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    public IResultMetadata getResultMetadata() {
        return this.resultMetadata;
    }
}

