/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.base;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.misc.MaterializerTaskState;

public abstract class AbstractReplicateOperatorDescriptor
extends AbstractOperatorDescriptor {
    protected static final long serialVersionUID = 1L;
    protected static final int SPLITTER_MATERIALIZER_ACTIVITY_ID = 0;
    protected static final int MATERIALIZE_READER_ACTIVITY_ID = 1;
    protected final boolean[] outputMaterializationFlags;
    protected final boolean requiresMaterialization;
    protected final int numberOfNonMaterializedOutputs;
    protected final int numberOfMaterializedOutputs;

    public AbstractReplicateOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputArity) {
        this(spec, rDesc, outputArity, new boolean[outputArity]);
    }

    public AbstractReplicateOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputArity, boolean[] outputMaterializationFlags) {
        super(spec, 1, outputArity);
        for (int i = 0; i < outputArity; ++i) {
            this.outRecDescs[i] = rDesc;
        }
        this.outputMaterializationFlags = outputMaterializationFlags;
        boolean reqMaterialization = false;
        int matOutputs = 0;
        int nonMatOutputs = 0;
        for (boolean flag : outputMaterializationFlags) {
            if (flag) {
                reqMaterialization = true;
                ++matOutputs;
                continue;
            }
            ++nonMatOutputs;
        }
        this.requiresMaterialization = reqMaterialization;
        this.numberOfMaterializedOutputs = matOutputs;
        this.numberOfNonMaterializedOutputs = nonMatOutputs;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ReplicatorMaterializerActivityNode sma = new ReplicatorMaterializerActivityNode(new ActivityId(this.odId, 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sma);
        builder.addSourceEdge(0, (IActivity)sma, 0);
        int pipelineOutputIndex = 0;
        int activityId = 1;
        for (int i = 0; i < this.outputArity; ++i) {
            if (this.outputMaterializationFlags[i]) {
                MaterializeReaderActivityNode mra = new MaterializeReaderActivityNode(new ActivityId(this.odId, activityId++));
                builder.addActivity((IOperatorDescriptor)this, (IActivity)mra);
                builder.addBlockingEdge((IActivity)sma, (IActivity)mra);
                builder.addTargetEdge(i, (IActivity)mra, 0);
                continue;
            }
            builder.addTargetEdge(i, (IActivity)sma, pipelineOutputIndex++);
        }
    }

    protected class MaterializeReaderActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MaterializeReaderActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
            return new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    MaterializerTaskState state = (MaterializerTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(AbstractReplicateOperatorDescriptor.this.getOperatorId(), 0), partition));
                    state.writeOut(this.writer, (IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), false);
                }
            };
        }
    }

    protected class ReplicatorMaterializerActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public ReplicatorMaterializerActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
            return new AbstractUnaryInputOperatorNodePushable(){
                private MaterializerTaskState state;
                private final IFrameWriter[] writers;
                private final boolean[] isOpen;
                {
                    this.writers = new IFrameWriter[AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs];
                    this.isOpen = new boolean[AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs];
                }

                public void open() throws HyracksDataException {
                    if (AbstractReplicateOperatorDescriptor.this.requiresMaterialization) {
                        this.state = new MaterializerTaskState(ctx.getJobletContext().getJobId(), new TaskId(ReplicatorMaterializerActivityNode.this.getActivityId(), partition), AbstractReplicateOperatorDescriptor.this.numberOfMaterializedOutputs);
                        this.state.open(ctx);
                    }
                    for (int i = 0; i < AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs; ++i) {
                        this.isOpen[i] = true;
                        this.writers[i].open();
                    }
                }

                public void nextFrame(ByteBuffer bufferAccessor) throws HyracksDataException {
                    if (AbstractReplicateOperatorDescriptor.this.requiresMaterialization) {
                        this.state.appendFrame(bufferAccessor);
                        bufferAccessor.clear();
                    }
                    for (int i = 0; i < AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs; ++i) {
                        FrameUtils.flushFrame((ByteBuffer)bufferAccessor, (IFrameWriter)this.writers[i]);
                    }
                }

                public void flush() throws HyracksDataException {
                    for (int i = 0; i < AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs; ++i) {
                        this.writers[i].flush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws HyracksDataException {
                    HyracksDataException hde = null;
                    try {
                        if (AbstractReplicateOperatorDescriptor.this.requiresMaterialization) {
                            this.state.close();
                            ctx.setStateObject((IStateObject)this.state);
                        }
                    }
                    finally {
                        for (int i = 0; i < AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs; ++i) {
                            if (!this.isOpen[i]) continue;
                            try {
                                this.writers[i].close();
                                continue;
                            }
                            catch (Throwable th) {
                                if (hde == null) {
                                    hde = HyracksDataException.create((Throwable)th);
                                    continue;
                                }
                                hde.addSuppressed(th);
                            }
                        }
                    }
                    if (hde != null) {
                        throw hde;
                    }
                }

                public void fail() throws HyracksDataException {
                    HyracksDataException hde = null;
                    for (int i = 0; i < AbstractReplicateOperatorDescriptor.this.numberOfNonMaterializedOutputs; ++i) {
                        if (!this.isOpen[i]) continue;
                        try {
                            this.writers[i].fail();
                            continue;
                        }
                        catch (Throwable th) {
                            if (hde == null) {
                                hde = HyracksDataException.create((Throwable)th);
                                continue;
                            }
                            hde.addSuppressed(th);
                        }
                    }
                    if (hde != null) {
                        throw hde;
                    }
                }

                public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                    this.writers[index] = writer;
                }
            };
        }
    }
}

