/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.sort;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.sort.Algorithm;
import org.apache.hyracks.dataflow.std.sort.ExternalSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ExternalSortRunMerger;

public class MicroSortRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int framesLimit;
    private final int[] sortFields;
    private final INormalizedKeyComputerFactory[] keyNormalizerFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;

    public MicroSortRuntimeFactory(int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, int[] projectionList, int framesLimit) {
        INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray;
        if (firstKeyNormalizerFactory != null) {
            INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray2 = new INormalizedKeyComputerFactory[1];
            iNormalizedKeyComputerFactoryArray = iNormalizedKeyComputerFactoryArray2;
            iNormalizedKeyComputerFactoryArray2[0] = firstKeyNormalizerFactory;
        } else {
            iNormalizedKeyComputerFactoryArray = null;
        }
        this(sortFields, iNormalizedKeyComputerFactoryArray, comparatorFactories, projectionList, framesLimit);
    }

    public MicroSortRuntimeFactory(int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, int[] projectionList, int framesLimit) {
        super(projectionList);
        if (projectionList != null) {
            throw new NotImplementedException("Cannot push projection into InMemorySortRuntime.");
        }
        this.sortFields = sortFields;
        this.keyNormalizerFactories = keyNormalizerFactories;
        this.comparatorFactories = comparatorFactories;
        this.framesLimit = framesLimit;
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(IHyracksTaskContext ctx) throws HyracksDataException {
        InMemorySortPushRuntime pushRuntime = new InMemorySortPushRuntime(ctx);
        ctx.registerDeallocatable((IDeallocatable)pushRuntime);
        return pushRuntime;
    }

    private class InMemorySortPushRuntime
    extends AbstractOneInputOneOutputPushRuntime
    implements IDeallocatable {
        final IHyracksTaskContext ctx;
        ExternalSortRunGenerator runsGenerator = null;
        ExternalSortRunMerger runsMerger = null;
        IFrameWriter wrappingWriter = null;

        private InMemorySortPushRuntime(IHyracksTaskContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void open() throws HyracksDataException {
            if (this.runsGenerator == null) {
                this.runsGenerator = new ExternalSortRunGenerator(this.ctx, MicroSortRuntimeFactory.this.sortFields, MicroSortRuntimeFactory.this.keyNormalizerFactories, MicroSortRuntimeFactory.this.comparatorFactories, this.outputRecordDesc, Algorithm.MERGE_SORT, EnumFreeSlotPolicy.LAST_FIT, MicroSortRuntimeFactory.this.framesLimit, Integer.MAX_VALUE);
            }
            this.isOpen = true;
            this.runsGenerator.open();
            this.runsGenerator.getSorter().reset();
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.runsGenerator.nextFrame(buffer);
        }

        public void close() throws HyracksDataException {
            Throwable failure = null;
            if (this.isOpen) {
                try {
                    if (!this.failed) {
                        this.runsGenerator.close();
                        this.createOrResetRunsMerger();
                        if (this.runsGenerator.getRuns().isEmpty()) {
                            this.wrappingWriter = this.runsMerger.prepareSkipMergingFinalResultWriter(this.writer);
                            this.wrappingWriter.open();
                            if (this.runsGenerator.getSorter().hasRemaining()) {
                                this.runsGenerator.getSorter().flush(this.wrappingWriter);
                            }
                        } else {
                            this.wrappingWriter = this.runsMerger.prepareFinalMergeResultWriter(this.writer);
                            this.wrappingWriter.open();
                            this.runsMerger.process(this.wrappingWriter);
                        }
                    }
                }
                catch (Throwable th) {
                    failure = th;
                    this.fail(th);
                }
                finally {
                    failure = CleanupUtils.close((IFrameWriter)this.wrappingWriter, (Throwable)failure);
                    this.wrappingWriter = null;
                }
            }
            this.isOpen = false;
            if (failure != null) {
                throw HyracksDataException.create((Throwable)failure);
            }
        }

        @Override
        public void fail() throws HyracksDataException {
            this.failed = true;
            if (this.runsGenerator != null) {
                List runs = this.runsGenerator.getRuns();
                int size = runs.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        ((GeneratedRunFileReader)runs.get(i)).close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.wrappingWriter != null) {
                this.wrappingWriter.fail();
            }
        }

        public void deallocate() {
            if (this.runsGenerator != null) {
                try {
                    this.runsGenerator.getSorter().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void createOrResetRunsMerger() {
            if (this.runsMerger == null) {
                IBinaryComparator[] comparators = new IBinaryComparator[MicroSortRuntimeFactory.this.comparatorFactories.length];
                for (int i = 0; i < MicroSortRuntimeFactory.this.comparatorFactories.length; ++i) {
                    comparators[i] = MicroSortRuntimeFactory.this.comparatorFactories[i].createBinaryComparator();
                }
                INormalizedKeyComputer nmkComputer = MicroSortRuntimeFactory.this.keyNormalizerFactories == null ? null : MicroSortRuntimeFactory.this.keyNormalizerFactories[0].createNormalizedKeyComputer();
                this.runsMerger = new ExternalSortRunMerger(this.ctx, this.runsGenerator.getRuns(), MicroSortRuntimeFactory.this.sortFields, comparators, nmkComputer, this.outputRecordDesc, MicroSortRuntimeFactory.this.framesLimit, Integer.MAX_VALUE);
            } else {
                this.runsMerger.reset(this.runsGenerator.getRuns());
            }
        }
    }
}

