/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws.parquet;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.input.HDFSDataSourceFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3ParquetReaderFactory
extends HDFSDataSourceFactory {
    private static final long serialVersionUID = -6140824803254158253L;
    private static final List<String> recordReaderNames = Collections.singletonList("S3");

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException, HyracksDataException {
        String path = AwsS3ParquetReaderFactory.buildPathURIs(configuration, warningCollector);
        AwsS3ParquetReaderFactory.putS3ConfToHadoopConf(configuration, path);
        JobConf conf = this.createHdfsConf(serviceCtx, configuration);
        int numberOfPartitions = this.getPartitionConstraint().getLocations().length;
        ExternalDataUtils.AwsS3.configureAwsS3HdfsJobConf(conf, configuration, numberOfPartitions);
        this.configureHdfsConf(conf, configuration);
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public Set<String> getReaderSupportedFormats() {
        return Collections.singleton("parquet");
    }

    private static void putS3ConfToHadoopConf(Map<String, String> configuration, String path) {
        configuration.put("path", path);
        configuration.put("input-format", "parquet-input-format");
        configuration.put("parser", "noop");
    }

    private static String buildPathURIs(Map<String, String> configuration, IWarningCollector warningCollector) throws CompilationException {
        String container = configuration.get("container");
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        List<S3Object> filesOnly = ExternalDataUtils.AwsS3.listS3Objects(configuration, includeExcludeMatcher, warningCollector);
        StringBuilder builder = new StringBuilder();
        if (!filesOnly.isEmpty()) {
            AwsS3ParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(0));
            for (int i = 1; i < filesOnly.size(); ++i) {
                builder.append(',');
                AwsS3ParquetReaderFactory.appendFileURI(builder, container, filesOnly.get(i));
            }
        }
        return builder.toString();
    }

    private static void appendFileURI(StringBuilder builder, String container, S3Object file) {
        builder.append("s3a");
        builder.append("://");
        builder.append(container);
        builder.append('/');
        builder.append(file.key());
    }
}

