/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.functions.IFunctionToDataSourceRewriter;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.UnnestToDataScanRule;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;

public class DatasetRewriter
implements IFunctionToDataSourceRewriter,
IResultTypeComputer {
    public static final DatasetRewriter INSTANCE = new DatasetRewriter();

    private DatasetRewriter() {
    }

    public boolean rewrite(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression f = UnnestToDataScanRule.getFunctionCall(opRef);
        if (f == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, ((ILogicalOperator)opRef.getValue()).getSourceLocation(), new Serializable[]{""});
        }
        UnnestOperator unnest = (UnnestOperator)opRef.getValue();
        if (unnest.getPositionalVariable() != null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, unnest.getSourceLocation(), new Serializable[]{"No positional variables are allowed over " + IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL)});
        }
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = DatasetRewriter.fetchDataset(metadataProvider, f);
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                int numPrimaryKeys = dataset.getPrimaryKeys().size();
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    variables.add(context.newVar());
                }
                break;
            }
            case EXTERNAL: {
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnest.getSourceLocation(), new Serializable[]{String.format("Unexpected %s type %s for %s %s", IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.SINGULAR), dataset.getDatasetType(), IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.SINGULAR), DatasetUtil.getFullyQualifiedDisplayName((Dataset)dataset))});
            }
        }
        variables.add(unnest.getVariable());
        DataSourceId dsid = new DataSourceId(dataset.getDataverseName(), dataset.getDatasetName());
        DataSource dataSource = metadataProvider.findDataSource(dsid);
        boolean hasMeta = dataSource.hasMeta();
        if (hasMeta) {
            variables.add(context.newVar());
        }
        DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)dataSource);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        opRef.setValue((Object)scan);
        this.addPrimaryKey(variables, dataSource, context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
        IAType[] schemaTypes = dataSource.getSchemaTypes();
        ARecordType recordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 2] : schemaTypes[schemaTypes.length - 1]);
        ARecordType metaRecordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 1] : null);
        EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess((ILogicalOperator)scan, variables, (ARecordType)recordType, (ARecordType)metaRecordType, (Dataset)dataset, (IOptimizationContext)context);
        return true;
    }

    private void addPrimaryKey(List<LogicalVariable> scanVariables, DataSource dataSource, IOptimizationContext context) {
        List primaryKey = dataSource.getPrimaryKeyVariables(scanVariables);
        ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>();
        tail.addAll(scanVariables);
        FunctionalDependency pk = new FunctionalDependency(primaryKey, tail);
        context.addPrimaryKey(pk);
    }

    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
        MetadataProvider metadata = (MetadataProvider)mp;
        AbstractFunctionCallExpression datasetFnCall = (AbstractFunctionCallExpression)expression;
        Dataset dataset = DatasetRewriter.fetchDataset(metadata, datasetFnCall);
        IAType type = metadata.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        if (type == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, datasetFnCall.getSourceLocation(), new Serializable[]{"No type for " + IdentifierUtil.dataset() + " " + dataset.getDatasetName()});
        }
        return type;
    }

    public static Dataset fetchDataset(MetadataProvider metadataProvider, AbstractFunctionCallExpression datasetFnCall) throws CompilationException {
        Dataset dataset;
        DatasetFullyQualifiedName datasetReference = FunctionUtil.parseDatasetFunctionArguments((AbstractFunctionCallExpression)datasetFnCall);
        DataverseName dataverseName = datasetReference.getDataverseName();
        String datasetName = datasetReference.getDatasetName();
        try {
            dataset = metadataProvider.findDataset(dataverseName, datasetName);
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (AlgebricksException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, (Throwable)e, datasetFnCall.getSourceLocation(), new Serializable[]{e.getMessage()});
        }
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, datasetFnCall.getSourceLocation(), new Serializable[]{datasetName, dataverseName});
        }
        return dataset;
    }
}

