/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.unnestingfunctions.std;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.unnestingfunctions.base.AbstractUnnestingFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class RangeDescriptor
extends AbstractUnnestingFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = RangeDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RANGE;
    }

    public IUnnestingEvaluatorFactory createUnnestingEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IUnnestingEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IUnnestingEvaluator createUnnestingEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IUnnestingEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    private IPointable inputVal = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private AMutableInt64 aInt64;
                    private long current;
                    private long max;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.aInt64 = new AMutableInt64(0L);
                    }

                    public void init(IFrameTupleReference tuple) throws HyracksDataException {
                        this.eval0.evaluate(tuple, this.inputVal);
                        this.current = ATypeHierarchy.getLongValue((String)RangeDescriptor.this.getIdentifier().getName(), (int)0, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
                        this.eval1.evaluate(tuple, this.inputVal);
                        this.max = ATypeHierarchy.getLongValue((String)RangeDescriptor.this.getIdentifier().getName(), (int)1, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
                    }

                    public boolean step(IPointable result) throws HyracksDataException {
                        if (this.current > this.max) {
                            return false;
                        }
                        this.aInt64.setValue(this.current);
                        this.resultStorage.reset();
                        this.serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                        result.set((IValueReference)this.resultStorage);
                        ++this.current;
                        return true;
                    }
                };
            }
        };
    }
}

