/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.column.values;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

/**
 * Accessor for key columns
 */
public interface IColumnKeyValueReader {
    /**
     * Reset the reader at the given index
     *
     * @param startIndex start index
     * @param skipCount  number of values should be skipped
     * @return return the number of encountered anti-matters
     */
    int reset(int startIndex, int skipCount) throws HyracksDataException;

    /**
     * Returns the value of the key at the given index
     *
     * @param index tuple index
     * @return the key value
     */
    IValueReference getValue(int index);
}
