/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.ExternalFunctionInfo;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.IntroduceDynamicTypeCastRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceDynamicTypeCastForExternalFunctionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    private boolean rewriteFunctionArgs(ILogicalOperator op, Mutable<ILogicalExpression> expRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)expRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean changed = false;
        AbstractFunctionCallExpression funcCallExpr = (AbstractFunctionCallExpression)expr;
        for (Mutable functionArgRef : funcCallExpr.getArguments()) {
            if (!this.rewriteFunctionArgs(op, (Mutable<ILogicalExpression>)functionArgRef, context)) continue;
            changed = true;
        }
        if (BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)funcCallExpr.getFunctionIdentifier()) != null) {
            return changed;
        }
        for (int i = 0; i < funcCallExpr.getArguments().size(); ++i) {
            boolean castFlag;
            Mutable argExpr = (Mutable)funcCallExpr.getArguments().get(i);
            IAType inputType = (IAType)op.computeOutputTypeEnvironment((ITypingContext)context).getType((ILogicalExpression)argExpr.getValue());
            IAType reqArgType = (IAType)((ExternalFunctionInfo)funcCallExpr.getFunctionInfo()).getParameterTypes().get(i);
            if (reqArgType.getTypeTag() == ATypeTag.OBJECT) {
                castFlag = !IntroduceDynamicTypeCastRule.compatible((ARecordType)reqArgType, inputType, op);
            } else if (reqArgType.getTypeTag() == ATypeTag.ANY) {
                IAType inputPrimeType = TypeComputeUtils.getActualType((IAType)inputType);
                castFlag = inputPrimeType.getTypeTag().isDerivedType();
            } else {
                castFlag = !reqArgType.equals(inputType);
            }
            boolean checkUnknown = false;
            while (NonTaggedFormatUtil.isOptional((IAType)inputType)) {
                inputType = ((AUnionType)inputType).getActualType();
                checkUnknown = true;
            }
            if (!castFlag && !checkUnknown) continue;
            ScalarFunctionCallExpression castFunc = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE));
            castFunc.setSourceLocation(((ILogicalExpression)argExpr.getValue()).getSourceLocation());
            castFunc.getArguments().add(argExpr);
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castFunc, (IAType)reqArgType, (IAType)inputType);
            funcCallExpr.getArguments().set(i, new MutableObject((Object)castFunc));
            changed = true;
        }
        return changed;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        boolean applied = op.acceptExpressionTransform(expr -> this.rewriteFunctionArgs((ILogicalOperator)op, (Mutable<ILogicalExpression>)expr, context));
        if (applied) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        return applied;
    }
}

