/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.IPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ExpectedSchemaNodeToIATypeTranslatorVisitor;
import org.apache.asterix.runtime.projection.ColumnDatasetProjectionFiltrationInfo;
import org.apache.asterix.runtime.projection.ExternalDatasetProjectionFiltrationInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;

public class PushdownProcessorsExecutor {
    private final List<IPushdownProcessor> processors = new ArrayList<IPushdownProcessor>();

    public void add(IPushdownProcessor processor) {
        this.processors.add(processor);
    }

    public boolean execute() throws AlgebricksException {
        boolean changed = false;
        for (IPushdownProcessor processor : this.processors) {
            changed |= processor.process();
        }
        return changed;
    }

    public void finalizePushdown(PushdownContext pushdownContext, IOptimizationContext context) {
        for (ScanDefineDescriptor scanDefineDescriptor : pushdownContext.getRegisteredScans()) {
            Dataset dataset = scanDefineDescriptor.getDataset();
            AbstractScanOperator scanOp = (AbstractScanOperator)scanDefineDescriptor.getOperator();
            IProjectionFiltrationInfo info = null;
            if (dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.COLUMN) {
                info = this.createInternalColumnarDatasetInfo(scanDefineDescriptor, context);
            } else if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (DatasetUtil.isFieldAccessPushdownSupported((Dataset)dataset) || DatasetUtil.isFilterPushdownSupported((Dataset)dataset))) {
                info = this.createExternalDatasetProjectionInfo(scanDefineDescriptor, context);
            }
            this.setInfoToDataScan(scanOp, info);
        }
    }

    private IProjectionFiltrationInfo createInternalColumnarDatasetInfo(ScanDefineDescriptor scanDefineDescriptor, IOptimizationContext context) {
        ARecordType metaRequestedType;
        Map<String, FunctionCallInformation> pathLocations = scanDefineDescriptor.getPathLocations();
        ARecordType recordRequestedType = ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE;
        Object object = metaRequestedType = scanDefineDescriptor.hasMeta() ? ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE : null;
        if (context.getPhysicalOptimizationConfig().isExternalFieldPushdown()) {
            ExpectedSchemaNodeToIATypeTranslatorVisitor converter = new ExpectedSchemaNodeToIATypeTranslatorVisitor(pathLocations);
            recordRequestedType = (ARecordType)scanDefineDescriptor.getRecordNode().accept(converter, scanDefineDescriptor.getDataset().getDatasetName());
            if (metaRequestedType != null) {
                metaRequestedType = (ARecordType)scanDefineDescriptor.getMetaNode().accept(converter, scanDefineDescriptor.getDataset().getDatasetName());
            }
        }
        return new ColumnDatasetProjectionFiltrationInfo(recordRequestedType, metaRequestedType, pathLocations, scanDefineDescriptor.getFilterPaths(), scanDefineDescriptor.getFilterExpression(), scanDefineDescriptor.getRangeFilterExpression());
    }

    private IProjectionFiltrationInfo createExternalDatasetProjectionInfo(ScanDefineDescriptor scanDefineDescriptor, IOptimizationContext context) {
        Map configuration;
        Map<String, FunctionCallInformation> pathLocations = scanDefineDescriptor.getPathLocations();
        ARecordType recordRequestedType = ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE;
        Dataset dataset = scanDefineDescriptor.getDataset();
        if (context.getPhysicalOptimizationConfig().isExternalFieldPushdown() && DatasetUtil.isFieldAccessPushdownSupported((Dataset)dataset)) {
            ExpectedSchemaNodeToIATypeTranslatorVisitor converter = new ExpectedSchemaNodeToIATypeTranslatorVisitor(pathLocations);
            recordRequestedType = (ARecordType)scanDefineDescriptor.getRecordNode().accept(converter, scanDefineDescriptor.getDataset().getDatasetName());
        }
        boolean embedFilterValues = ExternalDataPrefix.containsComputedFields((Map)(configuration = ((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties())) && Boolean.parseBoolean(configuration.getOrDefault("embed-filter-values", "true"));
        return new ExternalDatasetProjectionFiltrationInfo(recordRequestedType, pathLocations, scanDefineDescriptor.getFilterPaths(), scanDefineDescriptor.getFilterExpression(), embedFilterValues);
    }

    private void setInfoToDataScan(AbstractScanOperator scanOp, IProjectionFiltrationInfo info) {
        if (info == null) {
            return;
        }
        if (scanOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator dataScanOp = (DataSourceScanOperator)scanOp;
            dataScanOp.setProjectionFiltrationInfo(info);
        } else if (scanOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
            UnnestMapOperator unnestMapOp = (UnnestMapOperator)scanOp;
            unnestMapOp.setProjectionFiltrationInfo(info);
        } else if (scanOp.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) {
            LeftOuterUnnestMapOperator outerUnnestMapOp = (LeftOuterUnnestMapOperator)scanOp;
            outerUnnestMapOp.setProjectionFiltrationInfo(info);
        }
    }
}

