/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public final class ObjectSchemaNode
extends AbstractSchemaNestedNode {
    private final Int2IntMap fieldNameIndexToChildIndexMap;
    private final List<AbstractSchemaNode> children;
    private IntUnaryOperator nextIndex;

    public ObjectSchemaNode() {
        this.fieldNameIndexToChildIndexMap = new Int2IntOpenHashMap();
        this.children = new ArrayList<AbstractSchemaNode>();
        this.nextIndex = this::nextIndex;
    }

    ObjectSchemaNode(DataInput input, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        if (definitionLevels != null) {
            definitionLevels.put(this, new RunLengthIntArray());
        }
        int numberOfChildren = input.readInt();
        this.fieldNameIndexToChildIndexMap = new Int2IntOpenHashMap();
        ObjectSchemaNode.deserializeFieldNameIndexToChildIndex(input, this.fieldNameIndexToChildIndexMap, numberOfChildren);
        this.nextIndex = this.fieldNameIndexToChildIndexMap.containsKey(-1) ? this::emptyColumnIndex : this::nextIndex;
        this.children = new ArrayList<AbstractSchemaNode>();
        ObjectSchemaNode.deserializeChildren(input, this.children, numberOfChildren, definitionLevels);
    }

    public AbstractSchemaNode getOrCreateChild(IValueReference fieldName, ATypeTag childTypeTag, FlushColumnMetadata columnMetadata) throws HyracksDataException {
        int numberOfChildren = this.children.size();
        int fieldNameIndex = columnMetadata.getFieldNamesDictionary().getOrCreateFieldNameIndex(fieldName);
        int childIndex = this.fieldNameIndexToChildIndexMap.getOrDefault(fieldNameIndex, this.nextIndex.apply(fieldNameIndex));
        AbstractSchemaNode currentChild = childIndex == numberOfChildren ? null : this.children.get(childIndex);
        AbstractSchemaNode newChild = columnMetadata.getOrCreateChild(currentChild, childTypeTag);
        if (currentChild == null) {
            this.children.add(childIndex, newChild);
            this.fieldNameIndexToChildIndexMap.put(fieldNameIndex, childIndex);
        } else if (currentChild != newChild) {
            this.children.set(childIndex, newChild);
        }
        return newChild;
    }

    public void addChild(int fieldNameIndex, AbstractSchemaNode child) {
        int childIndex = this.children.size();
        this.fieldNameIndexToChildIndexMap.put(fieldNameIndex, childIndex);
        this.children.add(child);
    }

    public void setEmptyObject(FlushColumnMetadata columnMetadata) throws HyracksDataException {
        if (!this.children.isEmpty()) {
            return;
        }
        AbstractSchemaNode emptyChild = columnMetadata.getOrCreateChild(null, ATypeTag.MISSING);
        this.addChild(-1, emptyChild);
        this.nextIndex = this::emptyColumnIndex;
    }

    public AbstractSchemaNode getChild(int fieldNameIndex) {
        if (this.fieldNameIndexToChildIndexMap.containsKey(fieldNameIndex)) {
            return this.children.get(this.fieldNameIndexToChildIndexMap.get(fieldNameIndex));
        }
        return MissingFieldSchemaNode.INSTANCE;
    }

    public List<AbstractSchemaNode> getChildren() {
        return this.children;
    }

    public IntList getChildrenFieldNameIndexes() {
        return IntImmutableList.toList((IntStream)this.fieldNameIndexToChildIndexMap.int2IntEntrySet().stream().sorted(Comparator.comparingInt(Int2IntMap.Entry::getIntValue)).mapToInt(Int2IntMap.Entry::getIntKey));
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.OBJECT;
    }

    @Override
    public boolean isObjectOrCollection() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public <R, T> R accept(ISchemaNodeVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    @Override
    public void serialize(DataOutput output, PathInfoSerializer pathInfoSerializer) throws IOException {
        output.write(ATypeTag.OBJECT.serialize());
        output.writeInt(this.children.size());
        for (Int2IntMap.Entry fieldNameIndexChildIndex : this.fieldNameIndexToChildIndexMap.int2IntEntrySet()) {
            int fieldNameIndex = fieldNameIndexChildIndex.getIntKey();
            output.writeInt(fieldNameIndex);
            output.writeInt(fieldNameIndexChildIndex.getIntValue());
        }
        pathInfoSerializer.enter(this);
        for (AbstractSchemaNode child : this.children) {
            child.serialize(output, pathInfoSerializer);
        }
        pathInfoSerializer.exit(this);
    }

    public void abort(DataInputStream input, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        definitionLevels.put(this, new RunLengthIntArray());
        int numberOfChildren = input.readInt();
        this.fieldNameIndexToChildIndexMap.clear();
        ObjectSchemaNode.deserializeFieldNameIndexToChildIndex(input, this.fieldNameIndexToChildIndexMap, numberOfChildren);
        this.children.clear();
        ObjectSchemaNode.deserializeChildren(input, this.children, numberOfChildren, definitionLevels);
    }

    private static void deserializeFieldNameIndexToChildIndex(DataInput input, Int2IntMap fieldNameIndexToChildIndexMap, int numberOfChildren) throws IOException {
        for (int i = 0; i < numberOfChildren; ++i) {
            int fieldNameIndex = input.readInt();
            int childIndex = input.readInt();
            fieldNameIndexToChildIndexMap.put(fieldNameIndex, childIndex);
        }
    }

    private static void deserializeChildren(DataInput input, List<AbstractSchemaNode> children, int numberOfChildren, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        for (int i = 0; i < numberOfChildren; ++i) {
            children.add(AbstractSchemaNode.deserialize(input, definitionLevels));
        }
    }

    private int nextIndex(int fieldNameIndex) {
        return this.children.size();
    }

    private int emptyColumnIndex(int fieldNameIndex) {
        this.nextIndex = this::nextIndex;
        this.fieldNameIndexToChildIndexMap.remove(-1);
        this.fieldNameIndexToChildIndexMap.put(fieldNameIndex, 0);
        return 0;
    }
}

