/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema.visitor;

import java.util.List;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class SchemaBuilderFromIATypeVisitor
implements IATypeVisitor<Void, AbstractSchemaNode> {
    private final FlushColumnMetadata columnMetadata;
    private final List<List<String>> primaryKeys;
    private List<String> currentPrimaryKeyPath;
    private int processedPrimaryKeys;
    private int currentPathIndex;

    public SchemaBuilderFromIATypeVisitor(FlushColumnMetadata columnMetadata, List<List<String>> primaryKeys) {
        this.columnMetadata = columnMetadata;
        this.primaryKeys = primaryKeys;
        this.processedPrimaryKeys = 0;
    }

    public Void visit(ARecordType recordType, AbstractSchemaNode arg) {
        ObjectSchemaNode objectNode = (ObjectSchemaNode)arg;
        this.columnMetadata.enterLevel(objectNode);
        try {
            if (this.isProcessingPrimaryKeys()) {
                this.processPrimaryKeys(recordType, objectNode);
            }
            for (int i = 0; i < recordType.getFieldTypes().length; ++i) {
                this.processField(i, recordType, objectNode);
            }
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
        this.columnMetadata.exitLevel(objectNode);
        return null;
    }

    public Void visit(AbstractCollectionType collectionType, AbstractSchemaNode arg) {
        AbstractCollectionSchemaNode collectionNode = (AbstractCollectionSchemaNode)arg;
        IAType itemType = TypeComputeUtils.getActualType((IAType)collectionType.getItemType());
        this.columnMetadata.enterLevel(collectionNode);
        try {
            AbstractSchemaNode itemNode = collectionNode.getOrCreateItem(itemType.getTypeTag(), this.columnMetadata);
            itemType.accept((IATypeVisitor)this, (Object)itemNode);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
        this.columnMetadata.exitLevel(collectionNode);
        return null;
    }

    public Void visit(AUnionType unionType, AbstractSchemaNode arg) {
        throw new IllegalStateException(unionType.getTypeTag() + " is not a declared type");
    }

    public Void visitFlat(IAType flatType, AbstractSchemaNode arg) {
        if (this.isProcessingPrimaryKeys()) {
            ++this.processedPrimaryKeys;
        }
        return null;
    }

    private boolean isProcessingPrimaryKeys() {
        return this.processedPrimaryKeys < this.primaryKeys.size();
    }

    private void processPrimaryKeys(ARecordType recordType, ObjectSchemaNode objectNode) throws HyracksDataException {
        if (objectNode == this.columnMetadata.getRoot() || objectNode == this.columnMetadata.getMetaRoot()) {
            while (this.isProcessingPrimaryKeys()) {
                this.currentPrimaryKeyPath = this.primaryKeys.get(this.processedPrimaryKeys);
                this.currentPathIndex = 0;
                this.processPrimaryKeyPath(recordType, objectNode);
            }
        } else {
            ++this.currentPathIndex;
            this.processPrimaryKeyPath(recordType, objectNode);
        }
    }

    private void processPrimaryKeyPath(ARecordType recordType, ObjectSchemaNode objectNode) throws HyracksDataException {
        int fieldIndex = recordType.getFieldIndex(this.currentPrimaryKeyPath.get(this.currentPathIndex));
        if (fieldIndex < 0) {
            --this.currentPathIndex;
            return;
        }
        this.processField(fieldIndex, recordType, objectNode);
    }

    private void processField(int fieldIndex, ARecordType recordType, ObjectSchemaNode objectNode) throws HyracksDataException {
        IAType[] fieldTypes = recordType.getFieldTypes();
        String[] fieldNames = recordType.getFieldNames();
        FieldNamesDictionary dictionary = this.columnMetadata.getFieldNamesDictionary();
        if (this.isProcessingPrimaryKeys() && !fieldNames[fieldIndex].equals(this.currentPrimaryKeyPath.get(this.currentPathIndex))) {
            return;
        }
        int fieldNameIndex = dictionary.getOrCreateFieldNameIndex(fieldNames[fieldIndex]);
        AbstractSchemaNode childNode = objectNode.getChild(fieldNameIndex);
        if (!childNode.isNested() && childNode != MissingFieldSchemaNode.INSTANCE) {
            return;
        }
        IValueReference fieldName = dictionary.getFieldName(fieldNameIndex);
        IAType fieldType = TypeComputeUtils.getActualType((IAType)fieldTypes[fieldIndex]);
        AbstractSchemaNode child = objectNode.getOrCreateChild(fieldName, fieldType.getTypeTag(), this.columnMetadata);
        fieldType.accept((IATypeVisitor)this, (Object)child);
    }
}

