/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationMessageWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] message;
    private final DeploymentId deploymentId;
    private final String nodeId;
    private final NodeControllerService ncs;

    public ApplicationMessageWork(NodeControllerService ncs, byte[] message, DeploymentId deploymentId, String nodeId) {
        this.ncs = ncs;
        this.deploymentId = deploymentId;
        this.nodeId = nodeId;
        this.message = message;
    }

    public void run() {
        NCServiceContext ctx = this.ncs.getContext();
        try {
            IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IServiceContext)ctx);
            if (ctx.getMessageBroker() != null) {
                ctx.getMessageBroker().receivedMessage(data, this.nodeId);
            } else {
                LOGGER.log(Level.WARN, "Message was sent, but no Message Broker set!");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error in application message delivery!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Level logLevel() {
        return Level.TRACE;
    }

    public String toString() {
        return this.getName() + ": nodeId: " + this.nodeId;
    }
}

