/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.fulltext;

import com.google.common.collect.ImmutableList;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.runtime.fulltext.AbstractFullTextFilterDescriptor;
import org.apache.asterix.runtime.fulltext.IFullTextConfigDescriptor;
import org.apache.asterix.runtime.fulltext.IFullTextFilterDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;

public class FullTextConfigDescriptor
implements IFullTextConfigDescriptor {
    private static final long serialVersionUID = 2L;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String name;
    private final TokenizerCategory tokenizerCategory;
    private final ImmutableList<String> filterNames;

    public FullTextConfigDescriptor(String databaseName, DataverseName dataverseName, String name, TokenizerCategory tokenizerCategory, ImmutableList<String> filterNames) {
        this.databaseName = databaseName;
        this.dataverseName = dataverseName;
        this.name = name;
        this.tokenizerCategory = tokenizerCategory;
        this.filterNames = filterNames;
    }

    public static FullTextConfigDescriptor getDefaultFullTextConfig() {
        return new FullTextConfigDescriptor(null, null, null, TokenizerCategory.WORD, (ImmutableList<String>)ImmutableList.of());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IFullTextConfigEvaluatorFactory createEvaluatorFactory(ImmutableList<AbstractFullTextFilterDescriptor> filterDescriptors) {
        ImmutableList.Builder filtersBuilder = new ImmutableList.Builder();
        for (IFullTextFilterDescriptor filterDescriptor : filterDescriptors) {
            filtersBuilder.add((Object)filterDescriptor.createEvaluatorFactory());
        }
        return new FullTextConfigEvaluatorFactory(this.name, this.tokenizerCategory, filtersBuilder.build());
    }

    @Override
    public TokenizerCategory getTokenizerCategory() {
        return this.tokenizerCategory;
    }

    @Override
    public ImmutableList<String> getFilterNames() {
        return this.filterNames;
    }
}

